CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_ADR_MODE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_gs_adr_mode] 1;
exec [dbo].[global_lions_write_table_gs_adr_mode] 2;
exec [dbo].[global_lions_write_table_gs_adr_mode] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_ADR_MODE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                              CreateDate CreateUser                     UpdateDate UpdateUser                     '         
	UNION ALL
    SELECT '---- ---------------------------------------- ---------- ------------------------------ ---------- ------------------------------ '
--	        1234 1234567890123456789012345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',41),41) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_ADR_MODE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_AGENCY]
@mode int = 1
AS
BEGIN
/*
exec [dbo].global_lions_write_table_gs_agency 1;
exec [dbo].global_lions_write_table_gs_agency 2;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_AGENCY'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                            Status ABBREV     MasterCode CreateDate CreateUser                     UpdateDate UpdateUser            '
	UNION ALL
	SELECT '---- ---------------------------------------------------------------------- ------ ---------- ---------- ---------- ------------------------------ ---------- ----------------------'
--	        1234 1234567890123456789012345678901234567890123456789012345678901234567890 123456 1234567890 1234567890 1234567890 1234567890 1234567890 123456789012345678901234567890
	;
	
    
--	        1234 1234567890123456789012345678901234567890123456789012345678901234567890 1234567890 123456789012345678901234567890
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(ISNULL(ABBREV,'') + REPLICATE(' ',11),11) ABBREV,
		LEFT(ISNULL(MASTER_CODE,'') + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_AGENCY 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_AGENCY_MASTER]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_gs_agency_master] 1;
exec [dbo].[global_lions_write_table_gs_agency_master] 2;
exec [dbo].[global_lions_write_table_gs_agency_master] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_AGENCY_MASTER'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser                       '  
	UNION ALL
    SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------    '
--	        1234 123456789012345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(MASTER_CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_AGENCY_MASTER 
	ORDER BY MASTER_CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_APPEAL_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].global_lions_write_table_GS_APPEAL_TYPE 1;
exec [dbo].global_lions_write_table_GS_APPEAL_TYPE 2;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_APPEAL_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser                  '    
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'
--	        1234 123456789012345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_APPEAL_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_AUDIT_FUNCTION]
@mode int = 1
AS
BEGIN
/*
exec [dbo].global_lions_write_table_GS_AUDIT_FUNCTION 1;
exec [dbo].global_lions_write_table_GS_AUDIT_FUNCTION 2;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_AUDIT_FUNCTION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description CreateDate CreateUser                     UpdateDate UpdateUser                       '   
	UNION ALL
	SELECT '---- ----------- ---------- ------------------------------ ---------- ------------------------------'

--	        1234 12345678901 1234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',12),12) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_AUDIT_FUNCTION 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_BOND_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].global_lions_write_table_GS_BOND_TYPE 1;
exec [dbo].global_lions_write_table_GS_BOND_TYPE 2;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_BOND_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser     '                     
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------  '
--	        1234 123456789012345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_BOND_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_CASE_CLASS]
@mode int = 1
AS
BEGIN
/*
exec [dbo].global_lions_write_table_GS_CASE_CLASS 1;
exec [dbo].global_lions_write_table_GS_CASE_CLASS 2;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_CASE_CLASS'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser     '                     
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------  '
--	        1234 123456789012345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CASE_CLASS 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_CASE_STATUS]
@mode int = 1
AS
BEGIN
/*
exec [dbo].global_lions_write_table_GS_CASE_STATUS 1;
exec [dbo].global_lions_write_table_GS_CASE_STATUS 2;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_CASE_STATUS'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description     CreateDate CreateUser                     UpdateDate UpdateUser                    '
	UNION ALL
	SELECT '---- --------------- ---------- ------------------------------ ---------- ------------------------------ '

--	        1234 123456789012345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',16),16) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CASE_STATUS 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_CAUSE_ACT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].global_lions_write_table_GS_CAUSE_ACT 1;
exec [dbo].global_lions_write_table_GS_CAUSE_ACT 2;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_CAUSE_ACT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                            Status MasterCode BeginDate EndDate   CreateDate CreateUser                     UpdateDate UpdateUser      ' 
	UNION ALL
	SELECT '---- ---------------------------------------------------------------------- ------ ---------- --------- --------- ---------- ------------------------------ ---------- ------------------------------ '
	--SELECT 'MasterCode Description                         Status BeginDate EndDate   CreateDate CreateUser                     UpdateDate UpdateUser              '     
	--UNION ALL
 --   SELECT '---------- ----------------------------------- ------ --------- --------- ---------- ------------------------------ ---------- ------------------------------   '
--	        1234 123456789012345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(ISNULL(MASTER_CODE,'') + REPLICATE(' ',11),11) MASTER_CODE,
		LEFT(CASE WHEN BEGIN_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(BEGIN_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',10),10)+
		LEFT(CASE WHEN END_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(END_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',10),10)+

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CAUSE_ACT 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_CAUSE_ACT_MASTER]
@mode int = 1
AS
BEGIN
/*
exec [dbo].global_lions_write_table_GS_CAUSE_ACT_MASTER 1;
exec [dbo].global_lions_write_table_GS_CAUSE_ACT_MASTER 2;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_CAUSE_ACT_MASTER'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'MasterCode Description                         Status BeginDate EndDate   CreateDate CreateUser                     UpdateDate UpdateUser              '     
	UNION ALL
    SELECT '---------- ----------------------------------- ------ --------- --------- ---------- ------------------------------ ---------- ------------------------------   '
--	        1234567890 12345678901234567890123456789012345 123456 123456789 123456789 1234567890 12345678901234567890 1234567890 123456789012345678901234567890
IF @mode = 2
	SELECT 
		LEFT(ISNULL(MASTER_CODE,'') + REPLICATE(' ',11),11) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',36),36) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(CASE WHEN BEGIN_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(BEGIN_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',10),10) +
		LEFT(CASE WHEN END_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(END_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',10),10) +

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CAUSE_ACT_MASTER 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_CHARGE_CAT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_CHARGE_CAT] 1;
exec [dbo].[global_lions_write_table_GS_CHARGE_CAT] 2;
exec [dbo].[global_lions_write_table_GS_CHARGE_CAT] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_CHARGE_CAT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser                             '    
	UNION ALL
    SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',21),21) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CHARGE_CAT 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_CHARGE_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_CHARGE_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_CHARGE_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_CHARGE_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_CHARGE_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code                      Description                                                            Status CreateDate CreateUser                     UpdateDate UpdateUser             '
	UNION ALL
	SELECT '------------------------- ---------------------------------------------------------------------- ------ ---------- ------------------------------ ---------- ----------------------- '
--		    1234567890123456789012345
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser                             '    
	--UNION ALL
 --   SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',26),26) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CHARGE_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_CIVIL_POTEN]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_CIVIL_POTEN] 1;
exec [dbo].[global_lions_write_table_GS_CIVIL_POTEN] 2;
exec [dbo].[global_lions_write_table_GS_CIVIL_POTEN] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_CIVIL_POTEN'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser        '        
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CIVIL_POTEN 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_COLLECT_IND]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_COLLECT_IND] 1;
exec [dbo].[global_lions_write_table_GS_COLLECT_IND] 2;
exec [dbo].[global_lions_write_table_GS_COLLECT_IND] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_COLLECT_IND'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser    '     
	UNION ALL
	SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
	--SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser        '        
	--UNION ALL
	--SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',21),21) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_COLLECT_IND 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_COMMENT_CAT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_COMMENT_CAT] 1;
exec [dbo].[global_lions_write_table_GS_COMMENT_CAT] 2;
exec [dbo].[global_lions_write_table_GS_COMMENT_CAT] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_COMMENT_CAT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser      '             
	UNION ALL
	SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser    '     
	--UNION ALL
	--SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
	--SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser        '        
	--UNION ALL
	--SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',21),21) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_COMMENT_CAT 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_CONTROL_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_CONTROL_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_CONTROL_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_CONTROL_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_CONTROL_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser      '             
	--UNION ALL
	--SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
	SELECT 'Code Description                              CreateDate CreateUser                     UpdateDate UpdateUser        '        
	UNION ALL
	SELECT '---- ---------------------------------------- ---------- ------------------------------ ---------- ------------------------------' 
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser    '     
	--UNION ALL
	--SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
	--SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser        '        
	--UNION ALL
	--SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',41),41) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CONTROL_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_COUNTRY_CIT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_COUNTRY_CIT] 1;
exec [dbo].[global_lions_write_table_GS_COUNTRY_CIT] 2;
exec [dbo].[global_lions_write_table_GS_COUNTRY_CIT] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_COUNTRY_CIT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser   '             
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------ '
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser      '             
	--UNION ALL
	--SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
	--SELECT 'Code Description                              CreateDate CreateUser                     UpdateDate UpdateUser        '        
	--UNION ALL
	--SELECT '---- ---------------------------------------- ---------- ------------------------------ ---------- ------------------------------' 
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser    '     
	--UNION ALL
	--SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
	--SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser        '        
	--UNION ALL
	--SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_COUNTRY_CIT 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_COURT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_COURT] 1;
exec [dbo].[global_lions_write_table_GS_COURT] 2;
exec [dbo].[global_lions_write_table_GS_COURT] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_COURT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                              CreateDate CreateUser                     UpdateDate UpdateUser     '  
	UNION ALL
	SELECT '---- ---------------------------------------- ---------- ------------------------------ ---------- ------------------------------'
	--             1234567890123456789012345678901234567890
	--SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser   '             
	--UNION ALL
	--SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------ '
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser      '             
	--UNION ALL
	--SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
	--SELECT 'Code Description                              CreateDate CreateUser                     UpdateDate UpdateUser        '        
	--UNION ALL
	--SELECT '---- ---------------------------------------- ---------- ------------------------------ ---------- ------------------------------' 
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser    '     
	--UNION ALL
	--SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
	--SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser        '        
	--UNION ALL
	--SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',41),41) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_COURT 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_DEFEND_STAT_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_DEFEND_STAT_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_DEFEND_STAT_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_DEFEND_STAT_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_DEFEND_STAT_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                        Status CreateDate CreateUser                     UpdateDate UpdateUser    '              
	UNION ALL
	SELECT '---- -------------------------------------------------- ------ ---------- ------------------------------ ---------- ------------------------------ '
	--SELECT 'Code                      Description                                                            Status CreateDate CreateUser                     UpdateDate UpdateUser             '
	--UNION ALL
	--SELECT '------------------------- ---------------------------------------------------------------------- ------ ---------- ------------------------------ ---------- ----------------------- '
--		    1234567890123456789012345
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser                             '    
	--UNION ALL
 --   SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',51),51) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_DEFEND_STAT_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_DISP_REAS_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_DISP_REAS_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_DISP_REAS_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_DISP_REAS_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_DISP_REAS_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                            Type  Status CreateDate CreateUser                     UpdateDate UpdateUser     '                       
	UNION ALL
	SELECT '---- ---------------------------------------------------------------------- ----- ------ ---------- ------------------------------ ---------- ------------------------------'
	--SELECT 'Code                      Description                                                            Status CreateDate CreateUser                     UpdateDate UpdateUser             '
	--UNION ALL
	--SELECT '------------------------- ---------------------------------------------------------------------- ------ ---------- ------------------------------ ---------- ----------------------- '
--		    1234567890123456789012345
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser                             '    
	--UNION ALL
 --   SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',6),6) TYPE,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_DISP_REAS_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_DISP_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_DISP_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_DISP_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_DISP_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_DISP_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                            Type  Status CreateDate CreateUser                     UpdateDate UpdateUser     '                       
	UNION ALL
	SELECT '---- ---------------------------------------------------------------------- ----- ------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',6),6) TYPE,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_DISP_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_DISTRICT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_DISTRICT] 1;
exec [dbo].[global_lions_write_table_GS_DISTRICT] 2;
exec [dbo].[global_lions_write_table_GS_DISTRICT] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_DISTRICT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Description                                        CreateDate CreateUser                     UpdateDate UpdateUser     '       
	UNION ALL
	SELECT '-------- -------------------------------------------------- ---------- ------------------------------ ---------- ------------------------------'


IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',51),51) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_DISTRICT 
	ORDER BY DISTRICT
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_DOJ_DIVISION]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_DOJ_DIVISION] 1;
exec [dbo].[global_lions_write_table_GS_DOJ_DIVISION] 2;
exec [dbo].[global_lions_write_table_GS_DOJ_DIVISION] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_DOJ_DIVISION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                        Status CreateDate CreateUser                     UpdateDate UpdateUser          '   
	UNION ALL
	SELECT '---- -------------------------------------------------- ------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',51),51) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_DOJ_DIVISION 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_DOM_TERR_IND]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_DOM_TERR_IND] 1;
exec [dbo].[global_lions_write_table_GS_DOM_TERR_IND] 2;
exec [dbo].[global_lions_write_table_GS_DOM_TERR_IND] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_DOM_TERR_IND'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    Status CreateDate CreateUser                     UpdateDate UpdateUser       '        
	UNION ALL
	SELECT '---- ------------------------------ ------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_DOM_TERR_IND 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_EMPLOYER_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_EMPLOYER_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_EMPLOYER_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_EMPLOYER_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_EMPLOYER_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                  Status CreateDate CreateUser                     UpdateDate UpdateUser              '    
	UNION ALL
	SELECT '---- ------------------------------------------------------------ ------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',61),61) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_EMPLOYER_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_EXPERT_SIDE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_EXPERT_SIDE] 1;
exec [dbo].[global_lions_write_table_GS_EXPERT_SIDE] 2;
exec [dbo].[global_lions_write_table_GS_EXPERT_SIDE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_EXPERT_SIDE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description     CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser             '     
	UNION ALL
	SELECT '---- --------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',16),16) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_EXPERT_SIDE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_GENDER]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_GENDER] 1;
exec [dbo].[global_lions_write_table_GS_GENDER] 2;
exec [dbo].[global_lions_write_table_GS_GENDER] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_GENDER'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description CreateDate CreateUser                     UpdateDate UpdateUser            '     
	UNION ALL
	SELECT '---- ----------- ---------- ------------------------------ ---------- ------------------------------'
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',12),12) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_GENDER 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_GUIDE_DEPART]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_GUIDE_DEPART] 1;
exec [dbo].[global_lions_write_table_GS_GUIDE_DEPART] 2;
exec [dbo].[global_lions_write_table_GS_GUIDE_DEPART] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_GUIDE_DEPART'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                  CreateDate CreateUser                     UpdateDate UpdateUser                 '    
	UNION ALL
	SELECT '---- ------------------------------------------------------------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) DISTRICT,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',61),61) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_GUIDE_DEPART 
	ORDER BY CODE
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_HCARE_BUSN_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_HCARE_BUSN_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_HCARE_BUSN_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_HCARE_BUSN_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_HCARE_BUSN_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                  Status CreateDate CreateUser                     UpdateDate UpdateUser      '    
	UNION ALL
	SELECT '---- ------------------------------------------------------------ ------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',61),61) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_HCARE_BUSN_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_INCAR_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_INCAR_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_INCAR_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_INCAR_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_INCAR_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    Status CreateDate CreateUser                     UpdateDate UpdateUser     '      
	UNION ALL
	SELECT '---- ------------------------------ ------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_INCAR_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_INIT_STAT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_INIT_STAT] 1;
exec [dbo].[global_lions_write_table_GS_INIT_STAT] 2;
exec [dbo].[global_lions_write_table_GS_INIT_STAT] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_INIT_STAT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description CreateDate CreateUser                     UpdateDate UpdateUser             '   
	UNION ALL
	SELECT '---- ----------- ---------- ------------------------------ ---------- ------------------------------'
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',12),12) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_INIT_STAT 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_INITIATOR]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_INITIATOR] 1;
exec [dbo].[global_lions_write_table_GS_INITIATOR] 2;
exec [dbo].[global_lions_write_table_GS_INITIATOR] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_INITIATOR'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser           '      
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_INITIATOR 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_INST_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_INST_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_INST_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_INST_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_INST_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                         CreateDate CreateUser                     UpdateDate UpdateUser        '        
	UNION ALL
	SELECT '---- ----------------------------------- ---------- ------------------------------ ---------- ------------------------------'
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',36),36) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_INST_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_LIT_RESP]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_LIT_RESP] 1;
exec [dbo].[global_lions_write_table_GS_LIT_RESP] 2;
exec [dbo].[global_lions_write_table_GS_LIT_RESP] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_LIT_RESP'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                  Status CreateDate CreateUser                     UpdateDate UpdateUser          '      
	UNION ALL
	SELECT '---- ------------------------------------------------------------ ------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',61),61) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_LIT_RESP 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_MEASURE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_MEASURE] 1;
exec [dbo].[global_lions_write_table_GS_MEASURE] 2;
exec [dbo].[global_lions_write_table_GS_MEASURE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_MEASURE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser         '    
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_MEASURE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_OCCUPATION]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_OCCUPATION] 1;
exec [dbo].[global_lions_write_table_GS_OCCUPATION] 2;
exec [dbo].[global_lions_write_table_GS_OCCUPATION] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_OCCUPATION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                  Status CreateDate CreateUser                     UpdateDate UpdateUser          '      
	UNION ALL
	SELECT '---- ------------------------------------------------------------ ------ ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',61),61) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_OCCUPATION 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_ORDER_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_ORDER_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_ORDER_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_ORDER_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_ORDER_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                                                                                                  Status CreateDate CreateUser                     UpdateDate UpdateUser         '     
	UNION ALL
    SELECT '---- -------------------------------------------------------------------------------------------------------------------------------------------- ------ ---------- ------------------------------ ---------- ------------------------------'
	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',141),141) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_ORDER_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_PART_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_PART_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_PART_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_PART_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_PART_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser       '      
	UNION ALL
	SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',21),21) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_PART_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_PENALTY_PROVISION]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_PENALTY_PROVISION] 1;
exec [dbo].[global_lions_write_table_GS_PENALTY_PROVISION] 2;
exec [dbo].[global_lions_write_table_GS_PENALTY_PROVISION] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_PENALTY_PROVISION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code                      Description                                                            Status CreateDate CreateUser                     UpdateDate UpdateUser             '                    
	UNION ALL
	SELECT '------------------------- ---------------------------------------------------------------------- ------ ---------- ------------------------------ ---------- ------------------------------'
	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',26),26) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_PENALTY_PROVISION 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_PRIORITY]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_PRIORITY] 1;
exec [dbo].[global_lions_write_table_GS_PRIORITY] 2;
exec [dbo].[global_lions_write_table_GS_PRIORITY] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_PRIORITY'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description               CreateDate CreateUser                     UpdateDate UpdateUser          '     
	UNION ALL
	SELECT '---- ------------------------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',26),26) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_PRIORITY 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_PROG_CAT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_PROG_CAT] 1;
exec [dbo].[global_lions_write_table_GS_PROG_CAT] 2;
exec [dbo].[global_lions_write_table_GS_PROG_CAT] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_PROG_CAT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                            Status MasterCode CreateDate CreateUser                     UpdateDate UpdateUser         '           
	UNION ALL
	SELECT '---- ---------------------------------------------------------------------- ------ ---------- ---------- ------------------------------ ---------- ------------------------------'
	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(ISNULL(MASTER_CODE,'') + REPLICATE(' ',11),11) MASTER_CODE,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_PROG_CAT 
	ORDER BY MASTER_CODE, CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_PROG_CAT_MASTER]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_PROG_CAT_MASTER] 1;
exec [dbo].[global_lions_write_table_GS_PROG_CAT_MASTER] 2;
exec [dbo].[global_lions_write_table_GS_PROG_CAT_MASTER] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_PROG_CAT_MASTER'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'MasterCode Description                                        CreateDate CreateUser                     UpdateDate UpdateUser      '     
	UNION ALL
	SELECT '---------- -------------------------------------------------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(MASTER_CODE,'') + REPLICATE(' ',11),11) MASTER_CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',51),51) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_PROG_CAT_MASTER 
	ORDER BY MASTER_CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_RACE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_RACE] 1;
exec [dbo].[global_lions_write_table_GS_RACE] 2;
exec [dbo].[global_lions_write_table_GS_RACE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_RACE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser      '  
	UNION ALL
	SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------ '


IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',21),21) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_RACE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_RELIEF_LIABILITY]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_RELIEF_LIABILITY] 1;
exec [dbo].[global_lions_write_table_GS_RELIEF_LIABILITY] 2;
exec [dbo].[global_lions_write_table_GS_RELIEF_LIABILITY] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_RELIEF_LIABILITY'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser   '    
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'


IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_RELIEF_LIABILITY 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_RELIEF_REQUESTED_BY]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_RELIEF_REQUESTED_BY] 1;
exec [dbo].[global_lions_write_table_GS_RELIEF_REQUESTED_BY] 2;
exec [dbo].[global_lions_write_table_GS_RELIEF_REQUESTED_BY] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_RELIEF_REQUESTED_BY'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser   '     
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'


IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_RELIEF_REQUESTED_BY 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_RELIEF_STAGE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_RELIEF_STAGE] 1;
exec [dbo].[global_lions_write_table_GS_RELIEF_STAGE] 2;
exec [dbo].[global_lions_write_table_GS_RELIEF_STAGE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_RELIEF_STAGE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser   '     
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'


IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_RELIEF_STAGE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_RELIEF_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_RELIEF_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_RELIEF_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_RELIEF_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_RELIEF_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser   '     
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'


IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_RELIEF_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_REST_RECIPIENT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_REST_RECIPIENT] 1;
exec [dbo].[global_lions_write_table_GS_REST_RECIPIENT] 2;
exec [dbo].[global_lions_write_table_GS_REST_RECIPIENT] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_REST_RECIPIENT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser   '     
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'


IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',21),21) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_REST_RECIPIENT 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_REST_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_REST_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_REST_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_REST_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_REST_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    CreateDate CreateUser                     UpdateDate UpdateUser   '     
	UNION ALL
	SELECT '---- ------------------------------ ---------- ------------------------------ ---------- ------------------------------'


IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_REST_TYPE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_ROLE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_ROLE] 1;
exec [dbo].[global_lions_write_table_GS_ROLE] 2;
exec [dbo].[global_lions_write_table_GS_ROLE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_ROLE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                              Type  PartType Status Dispose CreateDate CreateUser                     UpdateDate UpdateUser           '    
	UNION ALL
	SELECT '---- ---------------------------------------- ----- -------- ------ ------- ---------- ------------------------------ ---------- ------------------------------'

	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',41),41) DESCRIPTION,
		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',6),6) TYPE,
		LEFT(ISNULL(PART_TYPE,'') + REPLICATE(' ',9),9) PART_TYPE,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(ISNULL(DISPOSE,'') + REPLICATE(' ',8),8) DISPOSE,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_ROLE 
	ORDER BY CODE
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_ROLLUP]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_ROLLUP] 1;
exec [dbo].[global_lions_write_table_GS_ROLLUP] 2;
exec [dbo].[global_lions_write_table_GS_ROLLUP] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_ROLLUP'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Disp DispReas CrimOrder  CreateDate CreateUser                     UpdateDate UpdateUser        '          
	UNION ALL
	SELECT '---- -------- ---------- ---------- ------------------------------ ---------- ------------------------------'
	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISPOSITION,'') + REPLICATE(' ',5),5) DISPOSITION,
		LEFT(ISNULL(DISP_REASON,'') + REPLICATE(' ',9),9) DISP_REASON,
		LEFT(ISNULL(CAST(CRIM_ORDER AS VARCHAR(10)),'') + REPLICATE(' ',11),11) CRIM_ORDER,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_ROLLUP 
	ORDER BY 1,2
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_SPEC_PROJ]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_SPEC_PROJ] 1;
exec [dbo].[global_lions_write_table_GS_SPEC_PROJ] 2;
exec [dbo].[global_lions_write_table_GS_SPEC_PROJ] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_SPEC_PROJ'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    Type  Status CreateDate CreateUser                     UpdateDate UpdateUser        ' 
	UNION ALL
	SELECT '---- ------------------------------ ----- ------ ---------- ------------------------------ ---------- ------------------------------'
	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',6),6) TYPE,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_SPEC_PROJ 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_SPECIAL_CONDITION]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_SPECIAL_CONDITION] 1;
exec [dbo].[global_lions_write_table_GS_SPECIAL_CONDITION] 2;
exec [dbo].[global_lions_write_table_GS_SPECIAL_CONDITION] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_SPECIAL_CONDITION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                    Status CreateDate CreateUser                     UpdateDate UpdateUser            '          
	UNION ALL
	SELECT '---- ------------------------------ ------ ---------- ------------------------------ ---------- ------------------------------'
	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_SPECIAL_CONDITION 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_SPECIAL_SERVICES]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_SPECIAL_SERVICES] 1;
exec [dbo].[global_lions_write_table_GS_SPECIAL_SERVICES] 2;
exec [dbo].[global_lions_write_table_GS_SPECIAL_SERVICES] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_SPECIAL_SERVICES'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                                 Status GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                  '  
	UNION ALL
	SELECT '---- --------------------------------------------------------------------------- ------ ------- ---------- ------------------------------ ---------- ------------------------------'
	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',76),76) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_SPECIAL_SERVICES 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_STATE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_STATE] 1;
exec [dbo].[global_lions_write_table_GS_STATE] 2;
exec [dbo].[global_lions_write_table_GS_STATE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_STATE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser                '         
	UNION ALL
	SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',21),21) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_STATE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_STORAGE_ITEM_NO]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_STORAGE_ITEM_NO] 1;
exec [dbo].[global_lions_write_table_GS_STORAGE_ITEM_NO] 2;
exec [dbo].[global_lions_write_table_GS_STORAGE_ITEM_NO] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_STORAGE_ITEM_NO'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                            CreateDate CreateUser                     UpdateDate UpdateUser         '           
	UNION ALL
	SELECT '---- ---------------------------------------------------------------------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_STORAGE_ITEM_NO 
	ORDER BY CAST(CODE AS INTEGER) 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_TERM_REASON]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_TERM_REASON] 1;
exec [dbo].[global_lions_write_table_GS_TERM_REASON] 2;
exec [dbo].[global_lions_write_table_GS_TERM_REASON] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_TERM_REASON'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser                '          
	UNION ALL
	SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',21),21) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_TERM_REASON 
	ORDER BY CODE
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_TRIBE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_TRIBE] 1;
exec [dbo].[global_lions_write_table_GS_TRIBE] 2;
exec [dbo].[global_lions_write_table_GS_TRIBE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_TRIBE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                                                            CreateDate CreateUser                     UpdateDate UpdateUser    '           
	UNION ALL
	SELECT '---- ---------------------------------------------------------------------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_TRIBE 
	ORDER BY CODE
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_TYPE_OF_ACTION_MAP]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_TYPE_OF_ACTION_MAP] 1;
exec [dbo].[global_lions_write_table_GS_TYPE_OF_ACTION_MAP] 2;
exec [dbo].[global_lions_write_table_GS_TYPE_OF_ACTION_MAP] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_TYPE_OF_ACTION_MAP'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code1  Code2 Status CreateDate CreateUser                     UpdateDate UpdateUser                '     
	UNION ALL
	SELECT '------ ----- ------ ---------- ------------------------------ ---------- ------------------------------'


	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE1,'') + REPLICATE(' ',7),7) CODE1,
		LEFT(ISNULL(CODE2,'') + REPLICATE(' ',6),6) CODE2,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,
		--LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',36),36) DESCRIPTION,
		--LEFT(ISNULL(TYPE,'') + REPLICATE(' ',6),6) TYPE,
		

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_TYPE_OF_ACTION_MAP 
	ORDER BY CODE2
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_US_ROLE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_US_ROLE] 1;
exec [dbo].[global_lions_write_table_GS_US_ROLE] 2;
exec [dbo].[global_lions_write_table_GS_US_ROLE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_US_ROLE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description                         Type  Status CreateDate CreateUser                     UpdateDate UpdateUser        '                
	UNION ALL
	SELECT '---- ----------------------------------- ----- ------ ---------- ------------------------------ ---------- ------------------------------'

	--      1234567890123456789012345
IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',36),36) DESCRIPTION,
		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',6),6) TYPE,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',7),7) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_US_ROLE 
	ORDER BY CODE 
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_VICTIM_TYPE]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_VICTIM_TYPE] 1;
exec [dbo].[global_lions_write_table_GS_VICTIM_TYPE] 2;
exec [dbo].[global_lions_write_table_GS_VICTIM_TYPE] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_VICTIM_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description CreateDate CreateUser                     UpdateDate UpdateUser        '      
	UNION ALL
	SELECT '---- ----------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',12),12) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_VICTIM_TYPE 
	ORDER BY CODE
	;
END
;

CREATE   PROCEDURE [dbo].[global_lions_write_table_GS_VICTIM_WIT]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[global_lions_write_table_GS_VICTIM_WIT] 1;
exec [dbo].[global_lions_write_table_GS_VICTIM_WIT] 2;
exec [dbo].[global_lions_write_table_GS_VICTIM_WIT] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'GS_VICTIM_WIT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'Code Description CreateDate CreateUser                     UpdateDate UpdateUser        '      
	UNION ALL
	SELECT '---- ----------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',12),12) DESCRIPTION,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_VICTIM_WIT 
	ORDER BY CODE
	;
END
;

CREATE   PROCEDURE [dbo].[redact_delete_expunge_cases]
AS
BEGIN
SET NOCOUNT ON
;
DECLARE @STAGE INT
SELECT @STAGE = MAX(stage)+1 FROM dbo.A1_INITIAL_DATA_PUMP
;
/*
++++++++++++++++++++++++++++++++++++++++++++
exec [redact_delete_expunge_cases]
;
select * from dbo.A1_INITIAL_DATA_PUMP order by id desc
;
select count(*) from GS_COMMENT
;
select count(*) from NL_EXPUNGED_LOG
;
++++++++++++++++++++++++++++++++++++++++++++
*/		
/*
		SELECT REPLACE(REPLACE(REPLACE(CONVERT(VARCHAR(100),GETDATE(),20),'-','_'),' ','_'),':','_')

        -- V_TABLE_NAME := 'GS_COMMENT';'SEALED_CIVIL' PROCESS_NAME 'MARKED_EXPUNGED' PROCESS_NAME
		DECLARE @cmd VARCHAR(4000)
		SELECT @cmd = 
		'SELECT T.*, GETDATE() AS DATA_DUMP INTO GS_COMMENT_' + 'MARKED_EXPUNGED' + '_' + REPLACE(REPLACE(REPLACE(CONVERT(VARCHAR(100),GETDATE(),20),'-','_'),' ','_'),':','_') + ' ' +
		'FROM 
		GS_COMMENT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = ''MARKED_EXPUNGED'')
		;'
*/

		DELETE T
		FROM 
		GS_COMMENT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(MARKED_EXPUNGED) DELETED FROM dbo.GS_COMMENT =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_COMMENT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(SEALED_CIVIL) DELETED FROM dbo.GS_COMMENT =>', @@ROWCOUNT, @STAGE)
		;

        --V_TABLE_NAME := 'GS_CONT_SERVICES';
		DELETE T
		FROM 
		GS_CONT_SERVICES T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES( '(MARKED_EXPUNGED) DELETED FROM dbo.GS_CONT_SERVICES =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_CONT_SERVICES T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES( '(SEALED_CIVIL) DELETED FROM dbo.GS_CONT_SERVICES =>', @@ROWCOUNT, @STAGE)
		;

        --V_TABLE_NAME := 'GS_AGENT';
		DELETE T
		FROM 
		GS_AGENT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(MARKED_EXPUNGED) DELETED FROM dbo.GS_AGENT =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_AGENT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(SEALED_CIVIL) DELETED FROM dbo.GS_AGENT =>', @@ROWCOUNT, @STAGE)
		;

        --V_TABLE_NAME := 'GS_ALSO_KNOWN';
		DELETE T
		FROM 
		GS_ALSO_KNOWN T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(MARKED_EXPUNGED) DELETED FROM dbo.GS_ALSO_KNOWN =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_ALSO_KNOWN T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(SEALED_CIVIL) DELETED FROM dbo.GS_ALSO_KNOWN =>', @@ROWCOUNT, @STAGE)
		;

        --V_TABLE_NAME := 'GS_OPPOSE_COUN';
		DELETE T
		FROM 
		GS_OPPOSE_COUN T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(MARKED_EXPUNGED) DELETED FROM dbo.GS_OPPOSE_COUN =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_OPPOSE_COUN T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(SEALED_CIVIL) DELETED FROM dbo.GS_OPPOSE_COUN =>', @@ROWCOUNT, @STAGE)
		;

        --V_TABLE_NAME := 'GS_CONTACT_LOG';
		DELETE T
		FROM 
		GS_CONTACT_LOG T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(MARKED_EXPUNGED) DELETED FROM dbo.GS_CONTACT_LOG =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_CONTACT_LOG T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(SEALED_CIVIL) DELETED FROM dbo.GS_CONTACT_LOG =>', @@ROWCOUNT, @STAGE)
		;

        --V_TABLE_NAME := 'GS_DEFEND_STAT';
		DELETE T
		FROM 
		GS_DEFEND_STAT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(MARKED_EXPUNGED) DELETED FROM dbo.GS_DEFEND_STAT =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_DEFEND_STAT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(SEALED_CIVIL) DELETED FROM dbo.GS_DEFEND_STAT =>', @@ROWCOUNT, @STAGE)
		;

        --V_TABLE_NAME := 'GS_PART_COUNT';
		DELETE T
		FROM 
		GS_PART_COUNT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(MARKED_EXPUNGED) DELETED FROM dbo.GS_PART_COUNT =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_PART_COUNT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(SEALED_CIVIL) DELETED FROM dbo.GS_PART_COUNT =>', @@ROWCOUNT, @STAGE)
		;

        --V_TABLE_NAME := 'GS_PART_COURT';
		DELETE T
		FROM 
		GS_PART_COURT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(MARKED_EXPUNGED) DELETED FROM dbo.GS_PART_COURT =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_PART_COURT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(SEALED_CIVIL) DELETED FROM dbo.GS_PART_COURT =>', @@ROWCOUNT, @STAGE)
		;

        --V_TABLE_NAME := 'GS_PART_EVENT';
		DELETE T
		FROM 
		GS_PART_EVENT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'MARKED_EXPUNGED')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(MARKED_EXPUNGED) DELETED FROM dbo.GS_PART_EVENT =>', @@ROWCOUNT, @STAGE)
		;
		DELETE T
		FROM 
		GS_PART_EVENT T
		INNER JOIN 
		NL_EXPUNGED_LOG L ON ( T.DISTRICT=L.DISTRICT) AND (T.CASEID = L.CASEID) AND (PROCESS_NAME = 'SEALED_CIVIL')
		;
		INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('(SEALED_CIVIL) DELETED FROM dbo.GS_PART_EVE

CREATE   PROCEDURE [dbo].[redact_nlions_gs_cases]
AS
BEGIN
SET NOCOUNT ON
;
/*
exec [redact_nlions_gs_cases]
;
*/
DECLARE @STAGE INT
SELECT @STAGE = MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
DECLARE @ROWCOUNT INT
;
/*
++++++++++++++++++++++++++++++++++++++++++++
select count(*) from [NLIONS].[GS_CASE]
;
select * from dbo.A1_INITIAL_DATA_PUMP order by id desc
;
++++++++++++++++++++++++++++++++++++++++++++
*/
------------------------------------ DEFINE FROM / TO dates   ---------------------------------------
DECLARE @DT_FROM DATETIME
DECLARE @DT_TO DATETIME

DECLARE @DT_FROM_STR VARCHAR(50)
DECLARE @DT_TO_STR  VARCHAR(50)

DECLARE @DB_DT DATETIME 
SELECT @DB_DT = DATEADD(day,1,CONVERT(DATE, CAST(RIGHT(DB_NAME(),10) AS VARCHAR(20)), 120))
;
SELECT @DB_DT
SELECT @DT_TO = DATEADD(ms,-3,@DB_DT)
;
SELECT @DT_FROM = DATEADD(year,-1,@DB_DT)
;
SELECT @DT_FROM, @DT_TO
;
SELECT @DT_FROM_STR =  CONVERT(VARCHAR(40),@DT_FROM,21), @DT_TO_STR =  CONVERT(VARCHAR(40),@DT_TO,21)
;
SELECT @DT_FROM_STR, @DT_TO_STR
;
-----------------------------------------------------------------------------------------------------


TRUNCATE TABLE [NLIONS].[GS_CASE]
;
INSERT INTO [NLIONS].[GS_CASE]
(
	 [ID]
	,[DISTRICT]
	,[CLASS]
	,[NAME]
	,[RECVD_DATE]
	,[SECURITY]
	,[PRIORITY]
	,[TYPE]
	,[US_ROLE]
	,[LIT_RESP]
	,[LIT_TRACK]
	,[WEIGHT]
	,[BRANCH]
	,[GRAND_JURY_NUM]
	,[UNIT]
	,[DCMNS_NUMBER]
	,[TRIBE]
	,[RESERVATION]
	,[SPEC_PROJ]
	,[VIC_WIT]
	,[ADR_MODE]
	,[COLLECT_IND]
	,[OFFENSE_FROM]
	,[OFFENSE_TO]
	,[LEAD_CHARGE]
	,[PHYSICAL_LOC]
	,[STORE_NUM]
	,[CIVIL_POTEN]
	,[SYS_INIT_DATE]
	,[ACCESS_DATE]
	,[STATUS]
	,[CLOSE_DATE]
	,[DEST_DATE]
	,[PERMANENT]
	,[CASE_RESTRICTED]
	,[CRIMINAL_POTEN]
	,[TOT_VICTIMS]
	,[RELATED_FLU_FLAG]
	,[QUI_TAM]
	-- --------------------
	,[CREATE_DATE]
	,[CREATE_USER]
	,[UPDATE_DATE]
	,[UPDATE_USER]
)
SELECT 
	   [ID]
      ,[DISTRICT]
      ,[CLASS]
      ,[NAME]
      ,[RECVD_DATE]
      ,[SECURITY]
      ,[PRIORITY]
      ,[TYPE]
      ,[US_ROLE]
      ,[LIT_RESP]
      ,[LIT_TRACK]
      ,[WEIGHT]
      ,[BRANCH]
      ,[GRAND_JURY_NUM]
      ,[UNIT]
      ,[DCMNS_NUMBER]
      ,[TRIBE]
      ,[RESERVATION]
      ,[SPEC_PROJ]
      ,[VIC_WIT]
      ,[ADR_MODE]
      ,[COLLECT_IND]
      ,[OFFENSE_FROM]
      ,[OFFENSE_TO]
      ,[LEAD_CHARGE]
      ,[PHYSICAL_LOC]
      ,[STORE_NUM]
      ,[CIVIL_POTEN]
      ,[SYS_INIT_DATE]
      ,[ACCESS_DATE]
      ,[STATUS]
      ,[CLOSE_DATE]
      ,[DEST_DATE]
      ,[PERMANENT]
      ,[CASE_RESTRICTED]
      ,[CRIMINAL_POTEN]
      ,[TOT_VICTIMS]
      ,[RELATED_FLU_FLAG]
      ,[QUI_TAM]
	  -- --------------------
      ,[CREATE_DATE]
      ,[CREATE_USER]
      ,[UPDATE_DATE]
      ,[UPDATE_USER]
FROM dbo.[GS_CASE]
where 1=1
--and STATUS = 'C'
and(
(CREATE_DATE between @DT_FROM and @DT_TO)
or
(UPDATE_DATE between @DT_FROM and @DT_TO) 
)
; 
SELECT @ROWCOUNT = @@ROWCOUNT
;
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'NARA=>REDACTED=>NLIONS.GS_CASE with [FILTER] => ' +  '(CREATE_DATE between ' + @DT_FROM_STR  + ' and ' + @DT_TO_STR + ')' + ' OR ' + '(UPDATE_DATE between ' + @DT_FROM_STR  + ' and ' + @DT_TO_STR + ')'  ,@ROWCOUNT,@STAGE 
;
DROP INDEX IF EXISTS [GS_CASE_PCON_IDX] ON [NLIONS].[GS_CASE];
CREATE UNIQUE CLUSTERED INDEX [GS_CASE_PCON_IDX] ON [NLIONS].[GS_CASE]
(
	[ID] ASC,
	[DISTRICT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, 
ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF)
;
END
;

CREATE   PROCEDURE [dbo].[redact_populate_log_tables]
AS

BEGIN
/*
exec [redact_populate_log_tables] 
;
*/
SET NOCOUNT ON
;
DECLARE @STAGE INT
SELECT @STAGE = MAX(stage)+1 FROM dbo.A1_INITIAL_DATA_PUMP
;

TRUNCATE TABLE [dbo].[NL_REDACTED_CASES_LOG]
;
-------------------------------------------------------------------------------------- SEALED
INSERT INTO [dbo].[NL_REDACTED_CASES_LOG] (DISTRICT, CASEID, PROCESS_NAME)
SELECT 
DISTINCT 
C.DISTRICT, C.ID, 'SEALED' PROCESS_NAME
FROM  
GS_CASE C,
GS_PARTICIPANT P,
GS_COURT_HIST CH
WHERE C.ID   = CH.CASEID  AND
C.DISTRICT  = CH.DISTRICT  AND
C.ID   = P.CASEID  AND
C.DISTRICT  = P.DISTRICT  AND
C.CLASS  = 'R'   AND
CH.COURT != 'NC'   AND
(CHARINDEX('SEALED', UPPER(P.LAST_NAME)) > 0 OR
CHARINDEX('SEALED', UPPER(ISNULL(P.FIRST_NAME,' '))) > 0 OR
CHARINDEX('UNDER SEAL', UPPER(P.LAST_NAME)) > 0 OR
CHARINDEX('UNDER SEAL', UPPER(ISNULL(P.FIRST_NAME,' '))) > 0 OR
CHARINDEX('SEALED', UPPER(C.NAME)) > 0 OR
CHARINDEX('UNDER SEAL', UPPER(C.NAME)) > 0  OR
C.SECURITY = 'L')   AND
CH.ID = (SELECT MAX(CH1.ID)
        FROM  GS_COURT_HIST CH1
        WHERE CH.DISTRICT  = CH1.DISTRICT AND
            CH.CASEID  = CH1.CASEID) 
-- 53,594 => 10 min
;
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('NL_REDACTED_CASES_LOG => SEALED ', @@ROWCOUNT, @STAGE);
-------------------------------------------------------------------------------------- SEALED(2)
INSERT INTO [dbo].[NL_REDACTED_CASES_LOG] (DISTRICT, CASEID, PROCESS_NAME)
SELECT 
DISTINCT C.DISTRICT, C.ID, 'SEALED' PROCESS_NAME
FROM  
GS_PARTICIPANT P,
GS_COURT_HIST CH,
GS_COURT_ORDER_DISP D,
GS_CASE C
LEFT JOIN
[dbo].[NL_REDACTED_CASES_LOG] AS S ON ( S.DISTRICT = C.DISTRICT AND S.CASEID = C.ID )
WHERE 
S.CASEID IS NULL AND
C.ID   = CH.CASEID  AND
C.DISTRICT  = CH.DISTRICT  AND
C.ID   = P.CASEID  AND
C.DISTRICT  = P.DISTRICT  AND
C.ID   = D.CASEID  AND
C.DISTRICT  = D.DISTRICT  AND
CH.ID = D.CRTHISID  AND
P.ID   = D.PARTID  AND
C.CLASS  = 'R'   AND
D.CODE='SEAL'
-- 148 
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('NL_REDACTED_CASES_LOG => SEALED(2) ', @@ROWCOUNT, @STAGE);

-------------------------------------------------------------------------------------- ONGOING
INSERT INTO [dbo].[NL_REDACTED_CASES_LOG] (DISTRICT, CASEID, PROCESS_NAME)
SELECT	
	DISTINCT C.DISTRICT, C.ID, 'ONGOING' PROCESS_NAME
FROM	
	GS_CASE C,
	GS_COURT_HIST CH,
	GS_PART_COURT PCRT
WHERE	C.ID = CH.CASEID AND
    C.DISTRICT = CH.DISTRICT AND
    CH.DISTRICT = PCRT.DISTRICT AND
    CH.CASEID = PCRT.CASEID	AND
    CH.ID = PCRT.CRTHISID AND
    C.DISTRICT IS NOT NULL AND
    C.CLASS = 'R' AND
    C.STATUS != 'C'	AND
    CH.FILING_DATE IS NULL AND
    CH.COURT IN ('NC', 'MM', 'MD') AND
    -- SINCE GS_INSTRUMENT.FILING_DATE IS CONSTRAINED (NOT NULL), CHECK FOR NO GS_INSTRUMENT RECORDS ASSOCIATED WITH THE MAX COURT HIST
    NOT EXISTS ( SELECT NULL
                FROM GS_INSTRUMENT I
		    WHERE CH.CASEID = I.CASEID AND
                CH.DISTRICT	= I.DISTRICT AND
                CH.ID = I.CRTHISID) AND
    -- THERE SHOULD BE NO CHARGES ASSOCIATED WITH THE MAX COURT_HIST ASSOCIATED WITH A PARTICIPANT
    NOT EXISTS ( SELECT NULL
                    FROM GS_PART_COUNT PC1
                    WHERE CH.CASEID = PC1.CASEID AND
                        CH.DISTRICT	= PC1.DISTRICT AND
		CH.ID = PC1.CRTHISID AND
		PCRT.PARTID = PC1.PARTID) AND
    -- AT LEAST ONE PARTICIPANT'S DISPOSITION DATE SHOULD BE BLANK
    PCRT.CRTHISID =	( SELECT MAX(PCRT1.CRTHISID)
                     	FROM GS_PART_COURT PCRT1
                        WHERE PCRT.CASEID = PCRT1.CASEID AND
				PCRT.DISTRICT = PCRT1.DISTRICT AND
				PCRT.PARTID = PCRT1.PARTID
			GROUP BY PCRT1.DISTRICT, PCRT1.CASEID, PCRT1.PARTID) AND
PCRT.DISP_DATE IS NULL 
-- 72,392
;
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('NL_REDACTED_CASES_LOG => ONGOING ', @@ROWCOUNT, @STAGE);
-------------------------------------------------------------------------------------- MARKED_EXPUNGED

TRUNCATE TABLE [dbo].[NL_EXPUNGED_LOG]
;
INSERT INTO [dbo].[NL_EXPUNGED_LOG] (DISTRICT, CASEID, PROCESS_NAME)
SELECT	C.DISTRICT, C.ID, 'MARKED_EXPUNGED' PROCESS_NAME
--INTO
--#MARKED_EXPUNGED
FROM 	GS_CASE C
WHERE	UPPER(C.NAME) LIKE '%EXPUNGE%'
UNION
SELECT	P.DISTRICT, P.CASEID, 'MARKED_EXPUNGED' PROCESS_NAME
FROM 	GS_PARTICIPANT P
WHERE	UPPER(ISNULL(P.LAST_NAME,'') +' '+ ISNULL(P.FIRST_NAME,'')) LIKE '%EXPUNGE%' 
UNION
SELECT  D.DISTRICT, D.CASEID, 'MARKED_EXPUNGED' PROCESS_NAME
FROM  GS_COURT_ORDER_DISP D
WHERE UPPER(D.CODE) ='NON'
;
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('NL_EXPUNGED_LOG => MARKED_EXPUNGED ', @@ROWCOUNT, @STAGE)
;

-------------------------------------------------------------------------------------- SEALED_CIVIL
INSERT INTO [dbo].[NL_EXPUNGED_LOG] (DISTRICT, CASEID, PROCESS_NAME)
SELECT DISTINCT 
C.DISTRICT, C.ID, 'SEALED_CIVIL' PROCESS_NAME
--INTO
--#SEALED_CIVIL
FROM  
GS_CASE C,
GS_PARTICIPANT P,
GS_COURT_HIST CH
WHERE C.ID   = CH.CASEID  AND
C.DISTRICT  = CH.DISTRICT  AND
C.ID   = P.CASEID  AND
C.DISTRICT  = P.DISTRICT  AND
C.CLASS  = 'V'   AND
CH.COURT != 'NC'   AND
(CHARINDEX('SEALED',UPPER(P.LAST_NAME)) > 0 OR
CHARINDEX('SEALED', UPPER(ISNULL(P.FIRST_NAME,' '))) > 0 OR
CHARINDEX( 'UNDER SEAL', UPPER(ISNULL(P.LAST_NAME,''))) > 0 OR
CHARINDEX('UNDER SEAL', UPPER(ISNULL(P.FIRST_NAME,' '))) > 0 OR
CHARINDEX(' XR ', UPPER(C.NAME)) > 0 OR
CHARINDEX('EX REL', UPPER(C.NAME)) > 0 OR
CHARINDEX('SEALED', UPPER(C.NAME)) > 0 OR
CHARINDEX('UNDER SEAL', UPPER(C.NAME)) > 0  OR
C.SECURITY = 'L')   AND
CH.ID = (SELECT MAX(CH1.ID)
FROM  GS_COURT_HIST CH1
WHERE CH.DISTRICT  = CH1.DISTRICT AND
CH.CASEID  = CH1.CASEID) 
UNION
SELECT DISTINCT C.DISTRICT, C.ID, 'SEALED_CIVIL' PROCESS_NAME
FROM  GS_CASE C
WHERE C.QUI_TAM='Y'
;
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('NL_EXPUNGED_LOG => SEALED_CIVIL ', @@ROWCOUNT, @STAGE)
;
-------------------------------------------------------------------------------------- POST_DISPOSITION
TRUNCATE TABLE [dbo].NL_REDACTED_PARTICIPANTS_LOG
;
INSERT INTO [dbo].NL_REDACTED_PARTICIPANTS_LOG (DISTRICT, CASEID, PARTID, PROCESS_NAME)
SELECT P.DISTRICT, P.CASEID, P.ID, 'POST_DISPOSITION' PROCESS_NAME
--INTO 
--#POST_DISPOSITION
FROM GS_PART_COURT PCR,
GS_PARTICIPANT P,
GS_COURT_HIST CH
WHERE P.CASEID  = PCR.CASEID  AND
P.DISTRICT = PCR.DISTRICT  AND
P.ID  = PCR.PARTID  AND
PCR.CASEID = CH.CASEID  AND
PCR.DISTRICT = CH.DISTRICT  AND
PCR.CRTHISID = CH.ID  AND
P.ROLE IN ( 'D', 'DB', 'DC', 'DG', 'DL', 'DP', 'DT', 'I',
            'P', 'PC', 'PL', 'PP', 'PR', 'PT', 'R' ) AND
EXISTS ( SELECT 'X'
            FROM  GS_INSTRUMENT I1
        WHERE CH.ID = I1.CRTHISID AND
                CH.DISTRICT = I1.DISTRICT AND
                CH.CASEID  = I1.CASEID   AND
                CH.COURT IN ( 'BC', 'CC', 'DC', 'MG', 'ST', 'TC', 'TR') )    AND
PCR.CRTHISID = ( SELECT MAX(PCR1.CRTHISID)
                    FROM GS_PART_COURT PCR1, GS_COURT_HIST CH1
                WHERE CH1.DISTRICT = PCR1.DISTRICT AND
                        CH1.CASEID = PCR1.CASEID AND
                        CH1.ID = PCR1.CRTHISID AND
                        PCR.DISTRICT = PCR1.DISTRICT AND
                        PCR.CASEID = PCR1.CASEID  AND
                        PCR.PARTID = PCR1.PARTID AND
                        CH1.COURT IN ( 'BC', 'CC', 'DC', 'MG', 'ST', 'TC', 'TR' ) ) AND
PCR.DISPOSITION IS NOT NULL AND
PCR.DISPOSITION NOT IN ('OE', 'NW') AND
PCR.DISP_DATE IS NOT NULL
;
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) VALUES('NL_REDACTED_PARTICIPANTS_LOG => POST_DISPOSITION ', @@ROWCOUNT, @STAGE)
;
------------------------------------------ ARCHIVE TABLES ( STATIC TABLES )

DELETE FROM [dbo].[A1_INITIAL_DATA_PUMP] W

-- /*(43)(05)(07)*/ exec [dbo].[trac_write_gs_order_type] 6;
CREATE     PROCEDURE [dbo].[trac_write_gs_order_type]
@mode int = 0
AS
BEGIN
----------------------------------------------------------- (43)(05)(07) ---------------------------------------------------------------------------
---------------------------------------------------------- GS_ORDER_TYPE ---------------------------------------------------------------------------
--------------------------------------/*(43)(05)(07)*/ exec [dbo].[trac_write_gs_order_type];   --------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(43)(05)(07)*/ exec [dbo].[trac_write_gs_order_type] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_triggerlock.txt',
DECLARE @ROWCOUNT INT
SELECT  @ROWCOUNT = COUNT(*) FROM GS_ORDER_TYPE WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_ORDER_TYPE',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 

		LEFT(ISNULL(CAST(CODE AS VARCHAR(4)),' ') + REPLICATE(' ',4),4) CODE,
		LEFT(ISNULL(CAST(DESCRIPTION AS VARCHAR(140)),' ') + REPLICATE(' ',140),140) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,' ') + REPLICATE(' ',1),1) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_ORDER_TYPE C
	WITH (NOLOCK)
) 
SELECT * FROM FSET
WHERE 1=1
ORDER BY CODE
;
IF @mode = 6
WITH FSET AS
(
	SELECT 

		LEFT(ISNULL(CAST(CODE AS VARCHAR(4)),' ') + REPLICATE(' ',4),4) CODE,
		LEFT(ISNULL(CAST(DESCRIPTION AS VARCHAR(140)),' ') + REPLICATE(' ',140),140) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,' ') + REPLICATE(' ',1),1) CODE_STAT,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_ORDER_TYPE C
	WITH (NOLOCK)
) 
SELECT * FROM FSET
WHERE 1=1
ORDER BY CODE
;
END
;

CREATE   PROCEDURE [dbo].[trac_write_gs_agent]
@mode AS int = 0
AS
BEGIN
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
--------------------------------------/****>(01)(02)(01)*/ exec [dbo].[trac_write_gs_agent] 6; --*TR1  (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_AGENT
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_AGENT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		
		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT('*'  + REPLICATE(' ',8),8) SALUTATION,
		LEFT('*'  + REPLICATE(' ',30),30) LAST_NAME,
		LEFT('*'  + REPLICATE(' ',30),30) FIRST_NAME,
		LEFT('*'  + REPLICATE(' ',30),30) TITLE,

		LEFT('*'  + REPLICATE(' ',20),20) PHONE,
		LEFT('*'  + REPLICATE(' ',15),15) FAX,
		LEFT('*'  + REPLICATE(' ',15),15) PAGER,

		LEFT(ISNULL(LEAD_AGENT,'') + REPLICATE(' ',1),1) LEAD_AGENT,
		LEFT('*'  + REPLICATE(' ',100),100) EMAIL,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_AGENT C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT *
FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		
		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT('*'  + REPLICATE(' ',8),8) SALUTATION,
		LEFT('*'  + REPLICATE(' ',30),30) LAST_NAME,
		LEFT('*'  + REPLICATE(' ',30),30) FIRST_NAME,
		LEFT('*'  + REPLICATE(' ',30),30) TITLE,

		LEFT('*'  + REPLICATE(' ',20),20) PHONE,
		LEFT('*'  + REPLICATE(' ',15),15) FAX,
		LEFT('*'  + REPLICATE(' ',15),15) PAGER,

		LEFT(ISNULL(LEAD_AGENT,'') + REPLICATE(' ',1),1) LEAD_AGENT,
		LEFT('*'  + REPLICATE(' ',100),100) EMAIL,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_AGENT C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	INNER JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT TOP 1000 * 
FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		
		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT('*'  + REPLICATE(' ',8),8) SALUTATION,
		LEFT('*'  + REPLICATE(' ',30),30) LAST_NAME,
		LEFT('*'  + REPLICATE(' ',30),30) FIRST_NAME,
		LEFT('*'  + REPLICATE(' ',30),30) TITLE,

		LEFT('*'  + REPLICATE(' ',20),20) PHONE,
		LEFT('*'  + REPLICATE(' ',15),15) FAX,
		LEFT('*'  + REPLICATE(' ',15),15) PAGER,

		LEFT(ISNULL(LEAD_AGENT,'') + REPLICATE(' ',1),1) LEAD_AGENT,
		LEFT('*'  + REPLICATE(' ',100),100) EMAIL,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,
		
		TR1.TR1_STATE AS RECORD_STATE,
		CASE 
		WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1_STATE=999 THEN 'SEALED'
		WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
		END STATE_DESCRIPTION
	FROM 
	GS_AGENT C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	INNER JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT TOP 1000 * 
FROM FSET
WHERE 1=1
ORDER BY RECORD_STATE,
CREATE    PROCEDURE [dbo].[trac_write_gs_also_known]
@mode AS int = 0
AS
BEGIN
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
--------------------------------------/****>(02)(02)(02)*/ exec [dbo].[trac_write_gs_also_known] 6;  --*TR1  (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************

	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
/*
SUBSTRING(RAW_DATA,1,10) DISTRICT,
SUBSTRING(RAW_DATA,11,10) CASEID,
SUBSTRING(RAW_DATA,21,10) PARTID,
SUBSTRING(RAW_DATA,31,10) ID,
SUBSTRING(RAW_DATA,41,60) LAST_NAME,
SUBSTRING(RAW_DATA,101,30) FIRST_NAME,
SUBSTRING(RAW_DATA,131,4) LAST_SOUNDS,
SUBSTRING(RAW_DATA,135,4) FIRST_SOUNDS,
SUBSTRING(RAW_DATA,139,11) CREATE_DATE,
SUBSTRING(RAW_DATA,150,30) CREATE_USER,
SUBSTRING(RAW_DATA,180,11) UPDATE_DATE,
SUBSTRING(RAW_DATA,191,30) UPDATE_USER
SQL
AK        1990V001051         248       *                                                           *                             *   *   17-NOV-2006           *                                                                                 |
AK        1990V001051         248       *                                                           *                             *   *   17-NOV-2006*                                                                       |
                                                                                                  100                                                                                                 200
         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +         +
1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890                            
ALN       2017R000827907788   46759720  *                                                           *                                     15-DEC-2017           *                             15-DEC-2017           *                             |
ALN       2017R000827907788   46759721  *                                                           *                                     15-DEC-2017*                             15-DEC-2017*                              |
ORACLE
*/
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_ALSO_KNOWN
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_ALSO_KNOWN',@ROWCOUNT,MAX(stage)+1 FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(CASE WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (BP.DISTRICT IS NOT NULL)) THEN ISNULL(C.LAST_NAME,'') ELSE '*' END + REPLICATE(' ',60),60) LAST_NAME,
		LEFT(CASE WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (BP.DISTRICT IS NOT NULL)) THEN ISNULL(C.FIRST_NAME,'') ELSE '*' END + REPLICATE(' ',60),60) FIRST_NAME,

		LEFT('*' + REPLICATE(' ',4),4) LAST_SOUNDS,
		LEFT('*' + REPLICATE(' ',4),4) FIRST_SOUNDS,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NOT NULL THEN '*' ELSE ISNULL(CREATE_USER,' ') END + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT(CASE WHEN UPDATE_USER IS NOT NULL THEN '*' ELSE ISNULL(UPDATE_USER,' ') END + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_ALSO_KNOWN C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.IND_CASE_LEVEL_GOV_DEFENDANT GD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = GD.DISTRICT
	AND C.CASEID = GD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_B_P_PR BP WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = BP.DISTRICT
	AND C.CASEID = BP.CASEID
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID 
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(CASE WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (BP.DISTRICT IS NOT NULL)) THEN ISNULL(C.LAST_NAME,'') ELSE '*' END + REPLICATE(' ',60),60) LAST_NAME,
		LEFT(CASE WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (BP.DISTRICT IS NOT NULL)) THEN ISNULL(C.FIRST_NAME,'') ELSE '*' END + REPLICATE(' ',60),60) FIRST_NAME,

		LEFT('*' + REPLICATE(' ',4),4) LAST_SOUNDS,
		LEFT('*' + REPLICATE(' ',4),4) FIRST_SOUNDS,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') A

CREATE    PROCEDURE [dbo].[trac_write_gs_assignment]  
@mode AS int = 0
AS
BEGIN
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
--------------------------------------/****>(03)(02)(03)*/ exec [dbo].[trac_write_gs_assignment] 6; --*TR1
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_ASSIGNMENT
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_ASSIGNMENT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(STAFFID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) STAFFID,

		LEFT(ISNULL(POSITION,'') + REPLICATE(' ',1),1) POSITION,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN START_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN END_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_ASSIGNMENT C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID 
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(STAFFID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) STAFFID,

		LEFT(ISNULL(POSITION,'') + REPLICATE(' ',1),1) POSITION,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN START_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN END_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_ASSIGNMENT C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT TOP 1000 * FROM FSET
ORDER BY DISTRICT, CASEID 
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(STAFFID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) STAFFID,

		LEFT(ISNULL(POSITION,'') + REPLICATE(' ',1),1) POSITION,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN START_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN END_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,


		TR1.TR1_STATE AS RECORD_STATE,
		CASE 
		WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1_STATE=999 THEN 'SEALED'
		WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
		END STATE_DESCRIPTION
	FROM 
	GS_ASSIGNMENT C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT 


CREATE   PROCEDURE [dbo].[trac_write_gs_case]
@mode AS int = 0
AS
BEGIN
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
--------------------------------------/****>(04)(01)(01)*/ exec [dbo].[trac_write_gs_case] 0;  
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
------------------------------------------------------------- GS_CASE -----------------------------------------------------------------
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_CASE
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_CASE',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
-- table_gs_case.txt
IF @mode = 0
WITH FSET AS
(
	SELECT --TOP 15000
	--TR1_CASEID, TR1_DISTRICT, RCL1.PROCESS_NAME SEAL,RCL2.PROCESS_NAME PRE_PUB,PDD.DISTRICT B4DD,TER.DISTRICT TERR, BP.DISTRICT BP,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.ID END,'') + REPLICATE(' ',10),10) CASEID,
	-- LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) /*OR (TR1.TR1_STATE = 700)*/ THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	LEFT(ISNULL(CLASS,'') + REPLICATE(' ',1),1) CLASS,

	LEFT(CASE WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (BP.DISTRICT IS NOT NULL)) THEN ISNULL(C.NAME,'') ELSE '*' END + REPLICATE(' ',50),50) NAME,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN RECVD_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(RECVD_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) RECVD_DATE,

	LEFT('*' + REPLICATE(' ',1),1) SECURITY,
	LEFT(CASE WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) THEN ISNULL(C.PRIORITY,'') ELSE '*' END + REPLICATE(' ',1),1)PRIORITY,
	LEFT(CASE WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) THEN ISNULL(C.TYPE,'') ELSE '*' END + REPLICATE(' ',4),4) TYPE,
	

	LEFT(ISNULL(US_ROLE,'') + REPLICATE(' ',2),2) US_ROLE,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE LIT_RESP END ,'') + REPLICATE(' ',2),2) LIT_RESP,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE LIT_TRACK END,'') + REPLICATE(' ',1),1) LIT_TRACK,
	LEFT(ISNULL(WEIGHT,'') + REPLICATE(' ',2),2) WEIGHT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE BRANCH END ,'') + REPLICATE(' ',3),3) BRANCH,

	LEFT('*' + REPLICATE(' ',15),15) GRAND_JURY_NUM,

	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE UNIT END,'') + REPLICATE(' ',4),4) UNIT,
	LEFT(ISNULL(DCMNS_NUMBER,'') + REPLICATE(' ',11),11) DCMNS_NUMBER,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE TRIBE END,'') + REPLICATE(' ',4),4) TRIBE,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE RESERVATION END,'') + REPLICATE(' ',4),4) RESERVATION,
	
	LEFT(CASE WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) THEN ISNULL(C.SPEC_PROJ,'') ELSE '*' END + REPLICATE(' ',2),2) SPEC_PROJ,

	LEFT(ISNULL(VIC_WIT,'') + REPLICATE(' ',1),1) VIC_WIT,
	LEFT(ISNULL(ADR_MODE,'') + REPLICATE(' ',2),2) ADR_MODE,
	LEFT(ISNULL(COLLECT_IND,'') + REPLICATE(' ',1),1) COLLECT_IND,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN OFFENSE_FROM IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(OFFENSE_FROM, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) OFFENSE_FROM,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN OFFENSE_TO IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(OFFENSE_TO, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) OFFENSE_TO,

	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN (TR1.TR1_STATE = 600) OR (RCL1.PROCESS_NAME IS NOT NULL) THEN '*' WHEN (TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NOT NULL) AND ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' ELSE ISNULL(C.LEAD_CHARGE,'') END + REPLICATE(' ',25),25) LEAD_CHARGE,
	
	--WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) THEN C.LEAD_CHARGE ELSE ' ' END + REPLICATE(' ',25),25) LEAD_CHARGE,

	LEFT('*' + REPLICATE(' ',20),20) PHYSICAL_LOC,
	LEFT('*' + REPLICATE(' ',20),20) STORE_NUM,
	LEFT('*' + REPLICATE(' ',1),1) CIVIL_POTEN,

	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN SYS_INIT_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(SYS_INIT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYS_INIT_DATE,
	LEFT(CASE WHEN ACCESS_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(ACCESS_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) ACCESS_DATE,

	LEFT(ISNULL(STATUS,'') + REPLICATE(' ',1),1) STATUS,
	LEFT(CASE WHEN CLOSE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CLOSE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CLOSE_DATE,
	LEFT(CASE WHEN DEST_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DEST_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DEST_DATE,

	LEFT(ISNULL(PERMANENT,'') + REPLICATE(' ',1),1) PERMANENT,

	LEFT('*' + REPLICATE(' ',1),1) CASE_RESTRICTED,
	LEFT('*' + REPLICATE(' ',1),1) CRIMINAL_POTEN,
	LEFT(ISNULL(CAST(TOT_VICTIMS AS VARCHAR(11)),'') + REPLICATE(' ',11),11) TOT_VICTIMS,
	LEFT(ISNULL(RELATED_FLU_FLAG,'') + REPLICATE(' ',1),1) RELATED_FLU_FLAG,
	LEFT(ISNULL(QUI_TAM,'') + REPLICATE(' ',1),1) QUI_TAM,

	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT(CASE WHEN CREATE_USER IS NOT NULL THEN '*' ELSE ISNULL(CREATE_USER,' ') END + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT(CASE WHEN UPDATE_USER IS NOT NULL THEN '*' ELSE ISNULL(UPDATE_USER,' ') END + REPLICATE(' ',30),30) UPDATE_USER

/*
--------------------------------------------
100 - TR1 Pre-Public After CutOff Date (18 cases)
600 - TR1 Pre-Public B4 Cut-Off date (821 case)
700 - TR1 Pre-Public Converted to Public (3 Cases)
--------------------------------------------
777 - Pre-Public Non-TR1
888 - Public
999 - Sealed
1000 - GOV-AS-DEFENDANT
2000 - BUS-OR-PROPERTY
--------------------------------------------
*/
	FROM 
	GS_CASE C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.ID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.ID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_GOV_DEFENDANT GD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = GD.DISTRICT
	AND C.ID = GD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_B_P_PR BP WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = BP.DISTRICT
	AND C.ID = BP.CASEID
	LEFT JOIN
CREATE    PROCEDURE [dbo].[trac_write_gs_case_cause_act]
@mode AS int = 0
AS
BEGIN
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
--------------------------------------/****>(05)(02)(04)*/ exec [dbo].[trac_write_gs_case_cause_act] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************

SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_CASE_CAUSE_ACT
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_CASE_CAUSE_ACT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
-- 'table_gs_case_cause_act.txt',
IF @mode = 0  
SELECT 
	LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAUSE_ACT,'') + REPLICATE(' ',4),4) CAUSE_ACT,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_CASE_CAUSE_ACT 
WITH (NOLOCK) 
ORDER BY 
DISTRICT, CASEID 
;
IF @mode = 4  
SELECT TOP 1000
	LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAUSE_ACT,'') + REPLICATE(' ',4),4) CAUSE_ACT,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_CASE_CAUSE_ACT 
WITH (NOLOCK) 
ORDER BY 
DISTRICT, CASEID DESC
;
IF @mode = 6  
SELECT TOP 1000
	LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAUSE_ACT,'') + REPLICATE(' ',4),4) CAUSE_ACT,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,
	TR1.TR1_STATE AS RECORD_STATE,
	CASE 
	WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
	WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
	WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
	----------
	WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
	WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
	WHEN TR1_STATE=999 THEN 'SEALED'
	WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
	WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
	END STATE_DESCRIPTION
FROM 
GS_CASE_CAUSE_ACT C
WITH (NOLOCK) 
LEFT JOIN
dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
ORDER BY RECORD_STATE, DISTRICT, CASEID
;
END
;



CREATE    PROCEDURE [dbo].[trac_write_gs_case_doj_div]
@mode AS int = 0
AS
BEGIN
----------------------------------------------------------------(06)(02)(05)------------------------------------------------------------------
------------------------------------------------------------- GS_CASE_DOJ_DIV ----------------------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
---------------------------------------------/*(06)(02)(05)*/ exec [dbo].[trac_write_gs_case_doj_div] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_CASE_DOJ_DIV
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_CASE_DOJ_DIV',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
-- 'table_gs_case_doj_div.txt',
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(DOJ_DIV,'') + REPLICATE(' ',4),4) DOJ_DIV,
		LEFT(ISNULL(DOJ_NUMBER,'') + REPLICATE(' ',25),25) DOJ_NUMBER,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_CASE_DOJ_DIV C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID 
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(DOJ_DIV,'') + REPLICATE(' ',4),4) DOJ_DIV,
		LEFT(ISNULL(DOJ_NUMBER,'') + REPLICATE(' ',25),25) DOJ_NUMBER,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_CASE_DOJ_DIV C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(DOJ_DIV,'') + REPLICATE(' ',4),4) DOJ_DIV,
		LEFT(ISNULL(DOJ_NUMBER,'') + REPLICATE(' ',25),25) DOJ_NUMBER,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,
		TR1.TR1_STATE AS RECORD_STATE,
		CASE 
		WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1_STATE=999 THEN 'SEALED'
		WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
		END STATE_DESCRIPTION
	FROM 
	GS_CASE_DOJ_DIV C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	INNER JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET
ORDER BY RECORD_STATE, DISTRICT, CASEID
;
END
;


CREATE    PROCEDURE [dbo].[trac_write_gs_case_dom_terr_ind]
@mode int = 0
AS
BEGIN
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
---------------------------------------------/****>(07)(02)(06)*/ exec [dbo].[trac_write_gs_case_dom_terr_ind] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_CASE_DOM_TERR_IND
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_CASE_DOM_TERR_IND',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
-- 'gs_case_dom_terr_ind.txt',
IF @mode = 0
WITH FSET AS
(
	SELECT --TOP 15000
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		-- ------------------------------------------------
		LEFT(
		CASE 
		WHEN (TR1.TR1_STATE = 100) THEN '#'
		ELSE 
			CASE
			WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL))  THEN '*'
			WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN CAST(ISNULL(C.ID,'') AS VARCHAR(10))
			ELSE '*'
			END
		END + REPLICATE(' ',10),10) ID,
		-- ------------------------------------------------
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		-- ------------------------------------------------
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		-- ------------------------------------------------
		LEFT(
		CASE 
		WHEN (TR1.TR1_STATE = 100) THEN '#'
		--WHEN C.DOM_TERR_IND IS NULL THEN ' ' 
		ELSE 
			CASE
			WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL))  THEN '*'
			WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN CAST(ISNULL(C.DOM_TERR_IND,'') AS VARCHAR(10))
			ELSE '*'
			END
		END + REPLICATE(' ',2),2) DOM_TERR_IND,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_CASE_DOM_TERR_IND C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
--ORDER BY C.CREATE_DATE DESC 
;

IF @mode = 4
WITH FSET AS
(
	SELECT --TOP 15000
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		-- ------------------------------------------------
		LEFT(
		CASE 
		WHEN (TR1.TR1_STATE = 100) THEN '#'
		ELSE 
			CASE
			WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL))  THEN '*'
			WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN CAST(ISNULL(C.ID,'') AS VARCHAR(10))
			ELSE '*'
			END
		END + REPLICATE(' ',10),10) ID,
		-- ------------------------------------------------
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END,'') + REPLICATE(' ',10),10) CASEID,
		-- ------------------------------------------------
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		-- ------------------------------------------------
		LEFT(
		CASE 
		WHEN (TR1.TR1_STATE = 100) THEN '#'
		--WHEN C.DOM_TERR_IND IS NULL THEN ' ' 
		ELSE 
			CASE
			WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL))  THEN '*'
			WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN CAST(ISNULL(C.DOM_TERR_IND,'') AS VARCHAR(10))
			ELSE '*'
			END
		END + REPLICATE(' ',2),2) DOM_TERR_IND,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_CASE_DOM_TERR_IND C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
--ORDER BY C.CREATE_DATE DESC 
;

IF @mode = 5
WITH FSET AS
(
	SELECT --TOP 15000
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		-- ------------------------------------------------
		LEFT(
		CASE 
		WHEN (TR1.TR1_STATE = 100) THEN '#'
		ELSE 
			CASE
			WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL))  THEN '*'
			WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN CAST(ISNULL(C.ID,'') AS VARCHAR(10))
			ELSE '*'
			END
		END + REPLICATE(' ',10),10) ID,
		-- ------------------------------------------------
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) E
CREATE   PROCEDURE [dbo].[trac_write_gs_case_prog_cat]
@mode int = 0
AS
BEGIN
----------------------------------------------------------------(08)(01)(02)----------------------------------------------------------------------
---------------------------------------------------------- GS_CASE_PROG_CAT ------------------------------------------------------------
-----------------------------------------/*(08)(01)(02)*/ exec [dbo].[trac_write_gs_case_prog_cat] 6; ----------------- ***-----------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
---------------------------------------------/****>(08)(01)(02)*/ exec [dbo].[trac_write_gs_case_prog_cat] 0;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_case_prog_cat.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_CASE_PROG_CAT
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_CASE_PROG_CAT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
SELECT --TOP 15000
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	--LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN C.PROG_CAT IS NULL THEN ' ' WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN C.PROG_CAT ELSE ' ' END + REPLICATE(' ',3),3) PROG_CAT,
	--LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN (TR1.TR1_STATE = 600) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND (PDD.DISTRICT IS NULL) AND (TER.DISTRICT IS NULL) THEN ISNULL(C.PROG_CAT,'') ELSE '*' END + REPLICATE(' ',3),3) PROG_CAT,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN (TR1.TR1_STATE = 600) OR (RCL1.PROCESS_NAME IS NOT NULL) THEN '*' WHEN (TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NOT NULL) AND ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' ELSE ISNULL(C.PROG_CAT,'') END + REPLICATE(' ',3),3) PROG_CAT,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER

/*
--------------------------------------------
100 - TR1 Pre-Public After CutOff Date (18 cases)
600 - TR1 Pre-Public B4 Cut-Off date (821 case)
700 - TR1 Pre-Public Converted to Public (3 Cases)
--------------------------------------------
777 - Pre-Public Non-TR1
888 - Public
999 - Sealed
1000 - GOV-AS-DEFENDANT
2000 - BUS-OR-PROPERTY
--------------------------------------------
*/
FROM 
	GS_CASE_PROG_CAT C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID 
;
IF @mode = 4
WITH FSET AS
(
SELECT --TOP 15000
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	--LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN C.PROG_CAT IS NULL THEN ' ' WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN C.PROG_CAT ELSE ' ' END + REPLICATE(' ',3),3) PROG_CAT,
	--LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN (TR1.TR1_STATE = 600) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND (PDD.DISTRICT IS NULL) AND (TER.DISTRICT IS NULL) THEN ISNULL(C.PROG_CAT,'') ELSE '*' END + REPLICATE(' ',3),3) PROG_CAT,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN (TR1.TR1_STATE = 600) OR (RCL1.PROCESS_NAME IS NOT NULL) THEN '*' WHEN (TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NOT NULL) AND ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' ELSE ISNULL(C.PROG_CAT,'') END + REPLICATE(' ',3),3) PROG_CAT,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER

/*
--------------------------------------------
100 - TR1 Pre-Public After CutOff Date (18 cases)
600 - TR1 Pre-Public B4 Cut-Off date (821 case)
700 - TR1 Pre-Public Converted to Public (3 Cases)
--------------------------------------------
777 - Pre-Public Non-TR1
888 - Public
999 - Sealed
1000 - GOV-AS-DEFENDANT
2000 - BUS-OR-PROPERTY
--------------------------------------------
*/
FROM 
	GS_CASE_PROG_CAT C
	WITH (NOLOCK) 
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID =
CREATE   PROCEDURE [dbo].[trac_write_gs_case_special_proj]
@mode int = 0
AS
BEGIN
---------------------------------------------------------------(09)(02)(07)-------------------------------------------------------------------------
---------------------------------------------------------- GS_CASE_SPECIAL_PROJ ----------------------------------------------------------------
-----------------------------------------/****>(09)(02)(07)*/ exec [dbo].[trac_write_gs_case_special_proj] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
---------------------------------------------/****>(09)(02)(07)*/ exec [dbo].[trac_write_gs_case_special_proj] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_CASE_SPECIAL_PROJ
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_CASE_SPECIAL_PROJ',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
-- 'gs_case_special_proj.txt',
IF @mode = 0
WITH FSET AS
(
SELECT --TOP 15000
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
	-- ------------------------------------------------
	LEFT(
	CASE 
	WHEN C.SPECIAL_PROJ IS NULL THEN ' ' 
	ELSE 
		CASE
		WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN C.SPECIAL_PROJ 
		ELSE '*'
		END
	END + REPLICATE(' ',2),2) SPECIAL_PROJ,
	-- ------------------------------------------------
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30)  CREATE_USER,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER
FROM 
	GS_CASE_SPECIAL_PROJ C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID 
;

IF @mode = 4
WITH FSET AS
(
SELECT --TOP 15000
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
	-- ------------------------------------------------
	LEFT(
	CASE 
	WHEN C.SPECIAL_PROJ IS NULL THEN ' ' 
	ELSE 
		CASE
		WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN C.SPECIAL_PROJ 
		ELSE '*'
		END
	END + REPLICATE(' ',2),2) SPECIAL_PROJ,
	-- ------------------------------------------------
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30)  CREATE_USER,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER
FROM 
	GS_CASE_SPECIAL_PROJ C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET
ORDER BY DISTRICT, CASEID DESC
;

IF @mode = 5
WITH FSET AS
(
SELECT --TOP 15000
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
	-- ------------------------------------------------
	LEFT(
	CASE 
	WHEN C.SPECIAL_PROJ IS NULL THEN ' ' 
	ELSE 
		CASE
		WHEN ((RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL)) THEN C.SPECIAL_PROJ 
		ELSE '*'
		END
	END + REPLICATE(' ',2),2) SPECIAL_PROJ,
	-- ------------------------------------------------
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30)  CREATE_USER,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER
FROM 
	GS_CASE_SPECIAL_PROJ C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1
CREATE   PROCEDURE [dbo].[trac_write_gs_comment]
@mode int = 0
AS
BEGIN
----------------------------------------------------------(10)(02)(08)-----------------------------------------------------------------------------
---------------------------------------------------------- GS_COMMENT ----------------------------------------------------------------
-----------------------------------------------/*(10)(02)(08)*/ exec [dbo].[trac_write_gs_comment] 6;-----------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
-----------------------------------------------/****>(10)(02)(08)*/ exec [dbo].[trac_write_gs_comment] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************

SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_COMMENT
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_COMMENT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
-- 'gs_comment.txt',
IF @mode = 0
WITH FSET AS
(
	SELECT --TOP 15000
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.ID1 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID1,
		LEFT(ISNULL(CAST(C.ID2 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID2,
		LEFT(ISNULL(C.CATEGORY,'') + REPLICATE(' ',1),1) CATEGORY,
		LEFT('*' + REPLICATE(' ',1),1) TEXT,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER
	FROM 
	dbo.GS_COMMENT C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID 
;

IF @mode = 4
WITH FSET AS
(
	SELECT --TOP 15000
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.ID1 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID1,
		LEFT(ISNULL(CAST(C.ID2 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID2,
		LEFT(ISNULL(C.CATEGORY,'') + REPLICATE(' ',1),1) CATEGORY,
		LEFT('*' + REPLICATE(' ',1),1) TEXT,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER
	FROM 
	dbo.GS_COMMENT C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET
ORDER BY DISTRICT, CASEID DESC
;

IF @mode = 5
WITH FSET AS
(
	SELECT --TOP 15000
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.ID1 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID1,
		LEFT(ISNULL(CAST(C.ID2 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID2,
		LEFT(ISNULL(C.CATEGORY,'') + REPLICATE(' ',1),1) CATEGORY,
		LEFT('*' + REPLICATE(' ',1),1) TEXT,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER
	FROM 
	dbo.GS_COMMENT C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELI
CREATE    PROCEDURE [dbo].[trac_write_gs_cont_services]
@mode int = 0
AS
BEGIN
-------------------------------------------------------------(11)(02)(09)---------------------------------------------------------------------------
---------------------------------------------------------- GS_CONT_SERVICES ----------------------------------------------------------------
--------------------------------------/*(11)(02)(09)*/ exec [dbo].[trac_write_gs_cont_services] 6;   -- (PARTID)------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
-----------------------------------------------/****>(11)(02)(09)*/ exec [dbo].[trac_write_gs_cont_services] 6;   -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_CONT_SERVICES
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_CONT_SERVICES',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
-- 'gs_cont_services.txt',
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT('*' + REPLICATE(' ',10),10) PARTID, -- *
		LEFT(ISNULL(CAST(C.CONTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) CONTID, --
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID, --

		LEFT( '*' + REPLICATE(' ',11),11) SERV_AGENCY,
		LEFT( '*' + REPLICATE(' ',4),4) SERV_TYPE,
		LEFT( '*' + REPLICATE(' ',3),3) SERV_LANGUAGE,
		LEFT( '*' + REPLICATE(' ',4),4) SERV_SPECIAL,

		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)   CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)   UPDATE_USER
	FROM 
	GS_CONT_SERVICES C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID 
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT('*' + REPLICATE(' ',10),10) PARTID, -- *
		LEFT(ISNULL(CAST(C.CONTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) CONTID, --
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID, --

		LEFT( '*' + REPLICATE(' ',11),11) SERV_AGENCY,
		LEFT( '*' + REPLICATE(' ',4),4) SERV_TYPE,
		LEFT( '*' + REPLICATE(' ',3),3) SERV_LANGUAGE,
		LEFT( '*' + REPLICATE(' ',4),4) SERV_SPECIAL,

		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)   CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)   UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1_STATE=999 THEN 'SEALED'
		WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
		END STATE_DESCRIPTION
	FROM 
	GS_CONT_SERVICES C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	INNER JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT TOP 1000 * FROM FSET
ORDER BY RECORD_STATE,DISTRICT, CASEID
--ORDER BY CONTID DESC, ID DESC
;
END
;

CREATE   PROCEDURE [dbo].[trac_write_gs_contact_log]
@mode int = 0
AS
BEGIN
------------------------------------------------------------(12)(02)(10)---------------------------------------------------------------------------
---------------------------------------------------------- GS_CONTACT_LOG ----------------------------------------------------------------
--------------------------------------/*(12)(02)(10)*/ exec [dbo].[trac_write_gs_contact_log] 6;   -- (PARTID)------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
-----------------------------------------------/****>(12)(02)(10)*/ exec [dbo].[trac_write_gs_contact_log] 6;   -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_CONTACT_LOG
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_CONTACT_LOG',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
-- 'gs_contact_log.txt',
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT( '*' + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		-- ------------------------------------------------
		LEFT( CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CONT_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CONT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CONT_DATE,
		LEFT( '*' + REPLICATE(' ',2),2) PURPOSE,
		LEFT( '*' + REPLICATE(' ',2),2) TYPE,
		LEFT( '*' + REPLICATE(' ',2),2) INITIATOR,
		LEFT( '*' + REPLICATE(' ',10),10) STAFFID,
		LEFT( '*' + REPLICATE(' ',3),3) DOC_CODE,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_CONTACT_LOG C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID 
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT( '*' + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		-- ------------------------------------------------
		LEFT( CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CONT_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CONT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CONT_DATE,
		LEFT( '*' + REPLICATE(' ',2),2) PURPOSE,
		LEFT( '*' + REPLICATE(' ',2),2) TYPE,
		LEFT( '*' + REPLICATE(' ',2),2) INITIATOR,
		LEFT( '*' + REPLICATE(' ',10),10) STAFFID,
		LEFT( '*' + REPLICATE(' ',3),3) DOC_CODE,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_CONTACT_LOG C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT TOP 1000 * FROM FSET
ORDER BY DISTRICT, CASEID DESC 
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT( '*' + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		-- ------------------------------------------------
		LEFT( CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CONT_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CONT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CONT_DATE,
		LEFT( '*' + REPLICATE(' ',2),2) PURPOSE,
		LEFT( '*' + REPLICATE(' ',2),2) TYPE,
		LEFT( '*' + REPLICATE(' ',2),2) INITIATOR,
		LEFT( '*' + REPLICATE(' ',10),10) STAFFID,
		LEFT( '*' + REPLICATE(' ',3),3) DOC_CODE,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US')
CREATE    PROCEDURE [dbo].[trac_write_gs_control_sub]
@mode int = 0
AS
BEGIN
------------------------------------------------------------(13)(03)(01)---------------------------------------------------------------------
---------------------------------------------------------- GS_CONTROL_SUB ----------------------------------------------------------------
--------------------------------------/*(13)(03)(01)*/ exec dbo.[trac_write_gs_control_sub] 6;-----------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
-----------------------------------------------/****>(13)(03)(01)*/ exec dbo.[trac_write_gs_control_sub] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
--  exec [dbo].[trac_write_gs_control_sub]
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_CONTROL_SUB
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_CONTROL_SUB',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
-- 'table_gs_control_sub.txt',
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',1),1) TYPE,
		LEFT(ISNULL(CAST(QUANTITY AS VARCHAR(14)),' ') + REPLICATE(' ',14),14) QUANTITY, -- <2023-02-02>
		LEFT(ISNULL(MEASURE,'') + REPLICATE(' ',1),1) MEASURE,
		LEFT(ISNULL(OTHER_DESCRIP,'') + REPLICATE(' ',30),30) OTHER_DESCRIP,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER
	FROM 
	GS_CONTROL_SUB C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID
;   
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',1),1) TYPE,
		LEFT(ISNULL(CAST(QUANTITY AS VARCHAR(14)),' ') + REPLICATE(' ',14),14) QUANTITY, -- <2023-02-02>
		LEFT(ISNULL(MEASURE,'') + REPLICATE(' ',1),1) MEASURE,
		LEFT(ISNULL(OTHER_DESCRIP,'') + REPLICATE(' ',30),30) OTHER_DESCRIP,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER
	FROM 
	GS_CONTROL_SUB C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT TOP 1000 * FROM FSET
ORDER BY DISTRICT, CASEID DESC
;   
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',1),1) TYPE,
		LEFT(ISNULL(CAST(QUANTITY AS VARCHAR(14)),' ') + REPLICATE(' ',14),14) QUANTITY, -- <2023-02-02>
		LEFT(ISNULL(MEASURE,'') + REPLICATE(' ',1),1) MEASURE,
		LEFT(ISNULL(OTHER_DESCRIP,'') + REPLICATE(' ',30),30) OTHER_DESCRIP,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30)  UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1_STATE=999 THEN 'SEALED'
		WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
		END STATE_DESCRIPTION
	FROM 
	GS_CONTROL_SUB C
	WITH (NOLOCK)

CREATE   PROCEDURE [dbo].[trac_write_gs_count]
@mode int = 0
AS
BEGIN
---------------------------------------------------------(14)(03)(02)-------------------------------------------------------------------------------
---------------------------------------------------------- GS_COUNT --------------------------------------------------------------------------------
-------------------------------------------------/*(14)(03)(02)*/ exec [dbo].[trac_write_gs_count] 6;-----------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
-----------------------------------------------/****>(14)(03)(02)*/ exec [dbo].[trac_write_gs_count] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_count.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_COUNT
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_COUNT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(C.INSTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) INSTID,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CHARGE,'') ELSE '*' END + REPLICATE(' ',25),25) CHARGE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CATEGORY,'') ELSE '*' END + REPLICATE(' ',1),1) CATEGORY,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.PENT_PROV,'') ELSE '*' END + REPLICATE(' ',25),25) PENT_PROV
	FROM 
	GS_COUNT C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID 
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(C.INSTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) INSTID,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CHARGE,'') ELSE '*' END + REPLICATE(' ',25),25) CHARGE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CATEGORY,'') ELSE '*' END + REPLICATE(' ',1),1) CATEGORY,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.PENT_PROV,'') ELSE '*' END + REPLICATE(' ',25),25) PENT_PROV
	FROM 
	GS_COUNT C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
)
SELECT TOP 1000 * FROM FSET
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(C.INSTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) INSTID,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CHARGE,'') ELSE '*' END + REPLICATE(' ',25),25) CHARGE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CATEGORY,'') ELSE '*' END + REPLICATE(' ',1),1) CATEGORY,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy',
CREATE    PROCEDURE [dbo].[trac_write_gs_court_hist]
@mode int = 0
AS
BEGIN
---------------------------------------------------------- (15)(05)(01) ---------------------------------------------------------------------------
---------------------------------------------------------- GS_COURT_HIST --------------------------------------------------------------------------
--------------------------------------/*(15)(05)(01)*/ exec [dbo].[trac_write_gs_court_hist] 4; ---------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
-----------------------------------------------/****>(15)(05)(01)*/ exec [dbo].[trac_write_gs_court_hist] 4;
-----------------------------------------------/****>(15)(05)(01)*/ exec [dbo].[trac_write_gs_court_hist] 5;
-----------------------------------------------/****>(15)(05)(01)*/ exec [dbo].[trac_write_gs_court_hist] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_court_hist.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_COURT_HIST
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_COURT_HIST',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT --TOP 1000
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(ISNULL(COURT,'') + REPLICATE(' ',2),2) COURT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE LOCATION END,'') + REPLICATE(' ',2),2) LOCATION,
		LEFT(ISNULL(US_ROLE,'') + REPLICATE(' ',2),2) US_ROLE,
		LEFT(CASE WHEN ((TR1.TR1_STATE = 100) OR (RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (BP.DISTRICT IS NOT NULL)) THEN ISNULL(C.COURT_NUMBER,'') ELSE '*' END + REPLICATE(' ',50),50) COURT_NUMBER,

		LEFT(CASE WHEN RCL1.CASEID IS NULL THEN ISNULL(UPPER(TRIM(CAST(FORMAT(FILING_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') ELSE '*'  END + REPLICATE(' ',11),11) FILING_DATE,
		LEFT(CASE WHEN SERVICE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SERVICE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SERVICE_DATE,
		LEFT(ISNULL(CAST(TRIAL_DAYS AS VARCHAR(14)),'') + REPLICATE(' ',14),14) TRIAL_DAYS,
		LEFT(CASE WHEN NOAP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(NOAP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) NOAP_DATE,
	
		LEFT(ISNULL(APPEAL_TYPE,'') + REPLICATE(' ',1),1) APPEAL_TYPE,
		LEFT(ISNULL(SENT_APPEAL,'') + REPLICATE(' ',1),1) SENT_APPEAL,
		LEFT(ISNULL(DISPOSITION,'') + REPLICATE(' ',2),2) DISPOSITION,
		LEFT(CASE WHEN DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DISP_DATE,

		LEFT(ISNULL(DISP_REASON1,'') + REPLICATE(' ',4),4) DISP_REASON1,
		LEFT(ISNULL(DISP_REASON2,'') + REPLICATE(' ',4),4) DISP_REASON2,
		LEFT(ISNULL(DISP_REASON3,'') + REPLICATE(' ',4),4) DISP_REASON3,

		LEFT(CASE WHEN SYS_DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SYS_DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYS_DISP_DATE,
		LEFT(CASE WHEN RCL1.CASEID IS NULL THEN ISNULL(UPPER(TRIM(CAST(FORMAT(SYS_FILING_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') ELSE '*' END + REPLICATE(' ',11),11) SYS_FILING_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_COURT_HIST C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID		
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_GOV_DEFENDANT GD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = GD.DISTRICT
	AND C.CASEID = GD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_B_P_PR BP WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = BP.DISTRICT
	AND C.CASEID = BP.CASEID
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
	WHERE 1=1
	--AND ((RCL1.PROCESS_NAME = 'SEALED-NEW') OR (RCL1.PROCESS_NAME IS NULL))
	--AND ((RCL2.PROCESS_NAME = 'PRE-PUBLIC') OR (RCL1.PROCESS_NAME IS NULL))
)
SELECT * FROM FSET
ORDER BY DISTRICT, CASEID
;

IF @mode = 4
WITH FSET AS
(
	SELECT --TOP 1000
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(ISNULL(COURT,'') + REPLICATE(' ',2),2) COURT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE LOCATION END,'') + REPLICATE(' ',2),2) LOCATION,
		LEFT(ISNULL(US_ROLE,'') + REPLICATE(' ',2),2) US_ROLE,
		LEFT(CASE WHEN ((TR1.TR1_STATE = 100) OR (RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (BP.DISTRICT IS NOT NULL)) THEN ISNULL(C.COURT_NUMBER,'') ELSE '*' END + REPLICATE(' ',50),50) COURT_NUMBER,

		LEFT(CASE WHEN RCL1.CASEID IS NULL THEN ISNULL(UPPER(TRIM(CAST(FORMAT(FILING_DATE
CREATE   PROCEDURE [dbo].[trac_write_gs_court_judge]
@mode int = 0
AS
BEGIN
------------------------------------------------------------(16)(03)(03)-----------------------------------------------------------------------
---------------------------------------------------------- GS_COURT_JUDGE ----------------------------------------------------------------
--------------------------------------/*(16)(03)(03)*/ exec [dbo].[trac_write_gs_court_judge] 4;-----------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
-----------------------------------------------/****>(16)(03)(03)*/ exec [dbo].[trac_write_gs_court_judge] 4;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_court_judge.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_COURT_JUDGE
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_COURT_JUDGE',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(JUDGEID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) JUDGEID,
		LEFT(ISNULL(CAST(DECISION AS VARCHAR(4)),'') + REPLICATE(' ',4),4) DECISION,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN START_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN END_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_COURT_JUDGE C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(JUDGEID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) JUDGEID,
		LEFT(ISNULL(CAST(DECISION AS VARCHAR(4)),'') + REPLICATE(' ',4),4) DECISION,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN START_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN END_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_COURT_JUDGE C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(JUDGEID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) JUDGEID,
		LEFT(ISNULL(CAST(DECISION AS VARCHAR(4)),'') + REPLICATE(' ',4),4) DECISION,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN START_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN END_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy
CREATE    PROCEDURE [dbo].[trac_write_gs_court_order_disp]
@mode int = 0
AS
BEGIN
----------------------------------------------------------------(17)(03)(04)----------------------------------------------------------------------------
---------------------------------------------------------- GS_COURT_ORDER_DISP ----------------------------------------------------------------
--------------------------------------/*(17)(03)(04)*/ exec [trac_write_gs_court_order_disp] 6;  -- (PARTID)-----------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
-----------------------------------------------/****>(17)(03)(04)*/ exec [trac_write_gs_court_order_disp];  -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_court_order_disp.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_COURT_ORDER_DISP WITH (NOLOCK) WHERE CODE = 'SEAL'
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_COURT_ORDER_DISP',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		--LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,

		LEFT(ISNULL(CODE,'') + REPLICATE(' ',4),4) CODE,
		LEFT(CASE WHEN SYSTEM_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SYSTEM_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYSTEM_DATE,
		LEFT('*' + REPLICATE(' ',11),11) DATE_OF_ORDER,

		LEFT('*' + REPLICATE(' ',60),60) LAST_NAME,
		LEFT('*' + REPLICATE(' ',30),30) FIRST_NAME,
		LEFT(ISNULL(COURT,'') + REPLICATE(' ',4),4) COURT,
		LEFT('*' + REPLICATE(' ',25),25) COURT_NUMBER,
		LEFT(ISNULL(CAST(PARTID2 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID2,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_COURT_ORDER_DISP C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		--LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,

		LEFT(ISNULL(CODE,'') + REPLICATE(' ',4),4) CODE,
		LEFT(CASE WHEN SYSTEM_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SYSTEM_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYSTEM_DATE,
		LEFT('*' + REPLICATE(' ',11),11) DATE_OF_ORDER,

		LEFT('*' + REPLICATE(' ',60),60) LAST_NAME,
		LEFT('*' + REPLICATE(' ',30),30) FIRST_NAME,
		LEFT(ISNULL(COURT,'') + REPLICATE(' ',4),4) COURT,
		LEFT('*' + REPLICATE(' ',25),25) COURT_NUMBER,
		LEFT(ISNULL(CAST(PARTID2 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID2,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1_STATE=999 THEN 'SEALED'
		WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
		END STATE_DESCRIPTION
	FROM 
	GS_COURT_ORDER_DISP C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	INNER JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY RECORD_STATE, DISTRICT, CASEID
--ORDER BY CRTHISID, COURT_NUMBER
;
END
;

CREATE   PROCEDURE [dbo].[trac_write_gs_defend_stat]
@mode int = 0
AS
BEGIN
----------------------------------------------------------------(18)(03)(05)----------------------------------------------------------------------------
---------------------------------------------------------- GS_DEFEND_STAT ----------------------------------------------------------------
--------------------------------------/*(18)(03)(05)*/ exec [trac_write_gs_defend_stat] 6;  -- (PARTID)-----------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(18)(03)(05)*/ exec [trac_write_gs_defend_stat];  -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_defend_stat.txt', AK        |
--                             1234567890
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_DEFEND_STAT WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_DEFEND_STAT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		-----------------------------
		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		-----------------------------
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.TYPE,'') ELSE '*' END + REPLICATE(' ',2),2) TYPE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN START_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE, -- TR1
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE ISNULL(CUSTODY_LOC,'') END,'') + REPLICATE(' ',2),2) CUSTODY_LOC, --TR1
		LEFT(ISNULL(DETEN_REASON,'') + REPLICATE(' ',4),4) DETEN_REASON, --''
		LEFT(ISNULL(BOND_TYPE,'') + REPLICATE(' ',2),2) BOND_TYPE, --''
		LEFT(ISNULL(CAST(BOND_AMOUNT AS VARCHAR(14)),'') + REPLICATE(' ',14),14) BOND_AMOUNT, --''
		LEFT('*' + REPLICATE(' ',25),25) BOND_PROVIDER,
		-----------------------------
		LEFT(ISNULL(TERM_REASON,'') + REPLICATE(' ',2),2) TERM_REASON,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN END_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE, -- TR1
		-----------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_DEFEND_STAT C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		-----------------------------
		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		-----------------------------
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.TYPE,'') ELSE '*' END + REPLICATE(' ',2),2) TYPE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN START_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE, -- TR1
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE ISNULL(CUSTODY_LOC,'') END,'') + REPLICATE(' ',2),2) CUSTODY_LOC, --TR1
		LEFT(ISNULL(DETEN_REASON,'') + REPLICATE(' ',4),4) DETEN_REASON, --''
		LEFT(ISNULL(BOND_TYPE,'') + REPLICATE(' ',2),2) BOND_TYPE, --''
		LEFT(ISNULL(CAST(BOND_AMOUNT AS VARCHAR(14)),'') + REPLICATE(' ',14),14) BOND_AMOUNT, --''
		LEFT('*' + REPLICATE(' ',25),25) BOND_PROVIDER,
		-----------------------------
		LEFT(ISNULL(TERM_REASON,'') + REPLICATE(' ',2),2) TERM_REASON,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN END_DATE IS NULL THEN ''  ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE, -- TR1
		-----------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_DEFEND_STAT C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
;
IF @mod
CREATE    PROCEDURE [dbo].[trac_write_gs_dna]
@mode int = 0
AS
BEGIN
--------------------------------------------------------(19)(03)(06)----------------------------------------------------------------------------
---------------------------------------------------------- GS_DNA ----------------------------------------------------------------
--------------------------------------/*(19)(03)(06)*/ exec [dbo].[trac_write_gs_dna] 4;-----------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(19)(03)(06)*/ exec [dbo].[trac_write_gs_dna] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_dna.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_DNA WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_DNA',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;	  
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',3),3) DISTRICT,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CASEID,'') + REPLICATE(' ',10),10) CASEID,
	
		LEFT(ISNULL(PROCEEDINGS_AFT_RELIEF_GRANTED,'') + REPLICATE(' ',1),1) PROCEEDINGS_AFT_RELIEF_GRANTED,
		LEFT(ISNULL(NEW_TRIAL_ORD,'') + REPLICATE(' ',1),1) NEW_TRIAL_ORD,
		LEFT(ISNULL(CHARGE_DISMISSED,'') + REPLICATE(' ',1),1) CHARGE_DISMISSED,
		LEFT(ISNULL(FOUND_GUILTY,'') + REPLICATE(' ',1),1) FOUND_GUILTY,
		LEFT(ISNULL(GUILTY_PLEA_ENTERED,'') + REPLICATE(' ',1),1) GUILTY_PLEA_ENTERED,

		LEFT(ISNULL(ACQUITTED,'') + REPLICATE(' ',1),1) ACQUITTED,
		LEFT(ISNULL(RESENTENCING_CAP_CASE,'') + REPLICATE(' ',1),1) RESENTENCING_CAP_CASE,
		LEFT(ISNULL(TESTING_ORDERED,'') + REPLICATE(' ',1),1) TESTING_ORDERED,
		LEFT(ISNULL(RELIEF_GRANTED,'') + REPLICATE(' ',1),1) RELIEF_GRANTED,
		LEFT('*' + REPLICATE(' ',1),1) COMMENTS,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NOT NULL THEN '*' ELSE ISNULL(CREATE_USER,' ') END + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT(CASE WHEN UPDATE_USER IS NOT NULL THEN '*' ELSE ISNULL(UPDATE_USER,' ') END + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
		GS_DNA
		WITH (NOLOCK)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
END
;

CREATE    PROCEDURE [dbo].[trac_write_gs_event]
	-- Add the parameters for the stored procedure here
	@l_district varchar(3),
	@mode int = 0
AS
BEGIN
-------------------------------------------------------- (20)(05)(02) ---------------------------------------------------------------------------
---------------------------------------------------------- GS_EVENT ------------------------------------------------------------------------
--------------------------------------/*(20)(05)(02)*/ exec [trac_write_gs_event] 'AZ', 4; -------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(20)(05)(02)*/ exec [trac_write_gs_event] 'NYS', 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_EVENT WITH (NOLOCK) WHERE DISTRICT = @l_district
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_EVENT ('+@l_district+')',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;	
IF @mode = 0
WITH FSET AS
(
	SELECT 
		--RCL1.PROCESS_NAME SEAL,
		--RCL2.PROCESS_NAME PRE_PUB,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(C.TYPE,'') ELSE '*' END + REPLICATE(' ',4),4) TYPE,
		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(C.ACTION,'') ELSE '*' END + REPLICATE(' ',2),2) ACTION,
		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(UPPER(TRIM(CAST(FORMAT(EVENT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') ELSE '*' END + REPLICATE(' ',11),11) EVENT_DATE,

		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(UPPER(TRIM(CAST(FORMAT(SCHED_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') ELSE '*' END + REPLICATE(' ',11),11) SCHED_DATE,
		LEFT(CASE WHEN SCHED_TIME IS NULL THEN ' ' ELSE CONVERT(VARCHAR(30),SCHED_TIME,8) END + REPLICATE(' ',11),11) SCHED_TIME,

		LEFT('*' + REPLICATE(' ',200),200) SCHED_LOC,
		LEFT(ISNULL(CAST(STAFFID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) STAFFID,
		LEFT(ISNULL(CAST(JUDGEID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) JUDGEID,
		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(DOCUMENT_CODE,'') ELSE '*' END + REPLICATE(' ',3),3) DOCUMENT_CODE,
		LEFT(ISNULL(CAST(DOCUMENT_STAFFID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) DOCUMENT_STAFFID,
		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(UPPER(TRIM(CAST(FORMAT(DOCUMENT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') ELSE '*' END + REPLICATE(' ',11),11) DOCUMENT_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_EVENT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.NL_REDACTED_CASES_LOG RCL2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL2.DISTRICT
	AND C.CASEID = RCL2.CASEID
	AND RCL2.PROCESS_NAME = 'PRE-PUBLIC'
	----------------------------
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)	
	WHERE 1=1
	AND C.DISTRICT = @l_district
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID, ID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		--RCL1.PROCESS_NAME SEAL,
		--RCL2.PROCESS_NAME PRE_PUB,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(C.TYPE,'') ELSE '*' END + REPLICATE(' ',4),4) TYPE,
		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(C.ACTION,'') ELSE '*' END + REPLICATE(' ',2),2) ACTION,
		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(UPPER(TRIM(CAST(FORMAT(EVENT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') ELSE '*' END + REPLICATE(' ',11),11) EVENT_DATE,

		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(UPPER(TRIM(CAST(FORMAT(SCHED_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') ELSE '*' END + REPLICATE(' ',11),11) SCHED_DATE,
		LEFT(CASE WHEN SCHED_TIME IS NULL THEN ' ' ELSE CONVERT(VARCHAR(30),SCHED_TIME,8) END + REPLICATE(' ',11),11) SCHED_TIME,

		LEFT('*' + REPLICATE(' ',200),200) SCHED_LOC,
		LEFT(ISNULL(CAST(STAFFID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) STAFFID,
		LEFT(ISNULL(CAST(JUDGEID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) JUDGEID,
		LEFT(CASE WHEN (RCL1.CASEID IS NULL) AND (RCL2.CASEID IS NULL) AND (TR1.TR1_STATE <> 100) AND (TR1.TR1_STATE <> 600) THEN ISNULL(DOCUMENT_CODE,'') ELSE '*' END + REPLICATE(
CREATE    PROCEDURE [dbo].[trac_write_gs_evidence]
@mode int = 0
AS
BEGIN
----------------------------------------------------------(21)(03)(07)----------------------------------------------------------------------------
---------------------------------------------------------- GS_EVIDENCE ----------------------------------------------------------------
--------------------------------------/*(21)(03)(07)*/ exec [dbo].[trac_write_gs_evidence] 6;-----------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(21)(03)(07)*/ exec [dbo].[trac_write_gs_evidence];
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_EVIDENCE WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_EVIDENCE',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;	  
-- 'gs_evidence.txt',
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,

		LEFT('*' + REPLICATE(' ',4),4) LOCATION,
		LEFT('*' + REPLICATE(' ',2),2) TYPE,
		LEFT(ISNULL(C.DISPOSITION,'') + REPLICATE(' ',1),1) DISPOSITION,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN STORE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(STORE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) STORE_DATE,
		LEFT(CASE WHEN DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DISP_DATE,

		LEFT( '*' + REPLICATE(' ',25),25) DC_EXHIBIT_NUM,
		LEFT( '*' + REPLICATE(' ',25),25) GJ_EXHIBIT_NUM,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_EVIDENCE C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID, ID
;

IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,

		LEFT('*' + REPLICATE(' ',4),4) LOCATION,
		LEFT('*' + REPLICATE(' ',2),2) TYPE,
		LEFT(ISNULL(C.DISPOSITION,'') + REPLICATE(' ',1),1) DISPOSITION,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN STORE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(STORE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) STORE_DATE,
		LEFT(CASE WHEN DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DISP_DATE,

		LEFT( '*' + REPLICATE(' ',25),25) DC_EXHIBIT_NUM,
		LEFT( '*' + REPLICATE(' ',25),25) GJ_EXHIBIT_NUM,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1_STATE=999 THEN 'SEALED'
		WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
		END STATE_DESCRIPTION
	FROM 
	GS_EVIDENCE C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	INNER JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY RECORD_STATE, DISTRICT, CASEID
;
END
;

CREATE   PROCEDURE [dbo].[trac_write_gs_expert_case]
@mode int = 0
AS
BEGIN
------------------------------------------------------_-----(22)(03)(08)----------------------------------------------------------------------------
---------------------------------------------------------- GS_EXPERT_CASE ----------------------------------------------------------------
--------------------------------------/*(22)(03)(08)*/ exec [dbo].[trac_write_gs_expert_case];
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(22)(03)(08)*/ exec [dbo].[trac_write_gs_expert_case] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'gs_expert_case.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_EXPERT_CASE WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_EXPERT_CASE',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(C.EXP_SIDE,' ') + REPLICATE(' ',1),1) EXP_SIDE,
		LEFT(ISNULL(CAST(C.EXPERTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) EXPERTID,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_EXPERT_CASE C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID, ID
;

IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(C.EXP_SIDE,' ') + REPLICATE(' ',1),1) EXP_SIDE,
		LEFT(ISNULL(CAST(C.EXPERTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) EXPERTID,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1_STATE=999 THEN 'SEALED'
		WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
		END STATE_DESCRIPTION

	FROM 
	GS_EXPERT_CASE C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	LEFT JOIN
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	INNER JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY RECORD_STATE, DISTRICT, CASEID
;
END
;

CREATE   PROCEDURE [dbo].[trac_write_gs_inst_charge]
@mode int = 0
AS
BEGIN
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(22)(03)(08)*/ exec [dbo].[trac_write_gs_inst_charge];
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
--'table_gs_inst_charge.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_INST_CHARGE WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_INST_CHARGE',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(IC.DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(IC.CASEID,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(INSTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) INSTID,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(IC.CHARGE,' ') END + REPLICATE(' ',25),25) CHARGE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(IC.CATEGORY,' ') END + REPLICATE(' ',1),1) CATEGORY,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(IC.PENT_PROV,' ') END + REPLICATE(' ',25),25) PENT_PROV,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NOT NULL THEN '*' ELSE ISNULL(CREATE_USER,' ') END + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT(CASE WHEN UPDATE_USER IS NOT NULL THEN '*' ELSE ISNULL(UPDATE_USER,' ') END + REPLICATE(' ',30),30) UPDATE_USER,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID
	FROM 
	GS_INST_CHARGE IC
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 ON 1=1
	AND IC.DISTRICT = RCL1.DISTRICT
	AND IC.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED'
	WHERE 0=1
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(IC.DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(IC.CASEID,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(INSTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) INSTID,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(IC.CHARGE,' ') END + REPLICATE(' ',25),25) CHARGE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(IC.CATEGORY,' ') END + REPLICATE(' ',1),1) CATEGORY,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(IC.PENT_PROV,' ') END + REPLICATE(' ',25),25) PENT_PROV,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NOT NULL THEN '*' ELSE ISNULL(CREATE_USER,' ') END + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT(CASE WHEN UPDATE_USER IS NOT NULL THEN '*' ELSE ISNULL(UPDATE_USER,' ') END + REPLICATE(' ',30),30) UPDATE_USER,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID
	FROM 
	GS_INST_CHARGE IC
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 ON 1=1
	AND IC.DISTRICT = RCL1.DISTRICT
	AND IC.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED'
	WHERE 0=1
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC 
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(IC.DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(IC.CASEID,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(INSTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) INSTID,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(IC.CHARGE,' ') END + REPLICATE(' ',25),25) CHARGE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(IC.CATEGORY,' ') END + REPLICATE(' ',1),1) CATEGORY,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(IC.PENT_PROV,' ') END + REPLICATE(' ',25),25) PENT_PROV,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NOT NULL THEN '*' ELSE ISNULL(CREATE_USER,' ') END + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT(CASE WHEN UPDATE_USER IS NOT NULL THEN '*' ELSE ISNULL(UPDATE_USER,' ') END + REPLICATE(' ',30),30) UPDATE_USER,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID
	FROM 
	GS_INST_CHARGE IC
	WITH (NOLOCK)
	LEFT JOIN
	dbo.NL_REDACTED_CASES_LOG RCL1 ON 1=1
	AND IC.DISTRICT = RCL1.DISTRICT
	AND IC.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED'
	WHERE 0=1
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC 
;
END
;

CREATE   PROCEDURE [dbo].[trac_write_gs_instrument]
@mode int = 0
AS
BEGIN
------------------------------------------------------------(24)(03)(09)----------------------------------------------------------------------------
---------------------------------------------------------- GS_INSTRUMENT ------------------------------------------------------------------------
---------------------------------------/****>(24)(03)(09)*/ exec [dbo].[trac_write_gs_instrument] 4;----------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(24)(03)(09)*/ exec [dbo].[trac_write_gs_instrument] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_instrument.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_INSTRUMENT WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_INSTRUMENT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.TYPE,' ') END + REPLICATE(' ',2),2) TYPE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(UPPER(TRIM(CAST(FORMAT(FILING_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') END + REPLICATE(' ',11),11) FILING_DATE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(UPPER(TRIM(CAST(FORMAT(SYS_FILING_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') END + REPLICATE(' ',11),11) SYS_FILING_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM
	GS_INSTRUMENT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.NL_REDACTED_CASES_LOG RCL1 ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.TYPE,' ') END + REPLICATE(' ',2),2) TYPE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(UPPER(TRIM(CAST(FORMAT(FILING_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') END + REPLICATE(' ',11),11) FILING_DATE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(UPPER(TRIM(CAST(FORMAT(SYS_FILING_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))),'') END + REPLICATE(' ',11),11) SYS_FILING_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM
	GS_INSTRUMENT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.NL_REDACTED_CASES_LOG RCL1 ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,

		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.TYPE,' ') END + REPLICATE(' ',2),2) TYPE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS
CREATE   PROCEDURE [dbo].[trac_write_gs_oppose_coun]
@mode int = 0
AS
BEGIN
-----------------------------------------------------------(25)(03)(10)----------------------------------------------------------------------------
---------------------------------------------------------- GS_OPPOSE_COUN ------------------------------------------------------------------------
--------------------------------------/*(25)(03)(10)*/ exec [dbo].[trac_write_gs_oppose_coun] 4;----------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(25)(03)(10)*/ exec [dbo].[trac_write_gs_oppose_coun] 4;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'gs_oppose_coun.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_OPPOSE_COUN WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_OPPOSE_COUN',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(C.ATTORNEYID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ATTORNEYID,
		-- ------------------------------------------------
		LEFT(ISNULL(C.TYPE,'') + REPLICATE(' ',2),2) TYPE,
		LEFT(CASE WHEN START_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE,
		LEFT(CASE WHEN END_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE,
		-- ------------------------------------------------
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_OPPOSE_COUN C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(C.ATTORNEYID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ATTORNEYID,
		-- ------------------------------------------------
		LEFT(ISNULL(C.TYPE,'') + REPLICATE(' ',2),2) TYPE,
		LEFT(CASE WHEN START_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE,
		LEFT(CASE WHEN END_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE,
		-- ------------------------------------------------
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_OPPOSE_COUN C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(C.PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(C.ATTORNEYID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ATTORNEYID,
		-- ------------------------------------------------
		LEFT(ISNULL(C.TYPE,'') + REPLICATE(' ',2),2) TYPE,
		LEFT(CASE WHEN START_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(START_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) START_DATE,
		LEFT(CASE WHEN END_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(END_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) END_DATE,
		-- ------------------------------------------------
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREAT
CREATE    PROCEDURE [dbo].[trac_write_gs_part_count]
@mode int = 0
AS
BEGIN
---------------------------------------------------------- (26)(05)(03) ---------------------------------------------------------------------------
---------------------------------------------------------- GS_PART_COUNT ------------------------------------------------------------------------
--------------------------------------/*(26)(05)(03)*/ exec [dbo].[trac_write_gs_part_count] 6;  -- (PARTID) ------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(26)(05)(03)*/ exec [dbo].[trac_write_gs_part_count];  -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_part_count.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_PART_COUNT WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_PART_COUNT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(INSTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) INSTID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CHARGE,' ') END + REPLICATE(' ',25),25) CHARGE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CATEGORY,' ') END + REPLICATE(' ',1),1) CATEGORY,

		LEFT(ISNULL(CAST(COUNTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) COUNTID,
		LEFT(ISNULL(DISPOSITION,'') + REPLICATE(' ',2),2) DISPOSITION,
		LEFT(ISNULL(DISP_REASON,'') + REPLICATE(' ',4),4) DISP_REASON,

		LEFT(CASE WHEN DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DISP_DATE,
		LEFT('*' + REPLICATE(' ',1),1) SEALED,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_COUNT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(INSTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) INSTID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CHARGE,' ') END + REPLICATE(' ',25),25) CHARGE,
		LEFT(CASE WHEN RCL1.PROCESS_NAME IS NOT NULL THEN '*' WHEN RCL1.PROCESS_NAME IS NULL THEN ISNULL(C.CATEGORY,' ') END + REPLICATE(' ',1),1) CATEGORY,

		LEFT(ISNULL(CAST(COUNTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) COUNTID,
		LEFT(ISNULL(DISPOSITION,'') + REPLICATE(' ',2),2) DISPOSITION,
		LEFT(ISNULL(DISP_REASON,'') + REPLICATE(' ',4),4) DISP_REASON,

		LEFT(CASE WHEN DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DISP_DATE,
		LEFT('*' + REPLICATE(' ',1),1) SEALED,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_COUNT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.NL_REDACTED_CASES_LOG RCL1 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = RCL1.DISTRICT
	AND C.CASEID = RCL1.CASEID
	AND RCL1.PROCESS_NAME = 'SEALED-NEW'
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE W
CREATE   PROCEDURE [dbo].[trac_write_gs_part_court]
@mode int = 0
AS
BEGIN
---------------------------------------------------------- (27)(05)(08) -----------------------------------------------------------------------------
---------------------------------------------------------- GS_PART_COURT ---------------------------------------------------------------------------
--------------------------------------/*(27)(05)(08)*/ exec [dbo].[trac_write_gs_part_court] 6;  ----------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(27)(05)(08)*/ exec [dbo].[trac_write_gs_part_court] 6;  -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_part_court.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_PART_COURT WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_PART_COURT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,

		LEFT(ISNULL(APPEAL_ROLE,'') + REPLICATE(' ',2),2) APPEAL_ROLE,
		LEFT(ISNULL(DISPOSITION,'') + REPLICATE(' ',2),2) DISPOSITION,
		LEFT(ISNULL(DISP_REASON,'') + REPLICATE(' ',4),4) DISP_REASON,

		LEFT(CASE WHEN DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DISP_DATE,
		LEFT(CASE WHEN SYS_DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SYS_DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYS_DISP_DATE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN SYS_INIT_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SYS_INIT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYS_INIT_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_COURT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,

		LEFT(ISNULL(APPEAL_ROLE,'') + REPLICATE(' ',2),2) APPEAL_ROLE,
		LEFT(ISNULL(DISPOSITION,'') + REPLICATE(' ',2),2) DISPOSITION,
		LEFT(ISNULL(DISP_REASON,'') + REPLICATE(' ',4),4) DISP_REASON,

		LEFT(CASE WHEN DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DISP_DATE,
		LEFT(CASE WHEN SYS_DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SYS_DISP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYS_DISP_DATE,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN SYS_INIT_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SYS_INIT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYS_INIT_DATE,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_COURT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,

		LEFT(ISNULL(APPEAL_ROLE,'') + REPLICATE(' ',2),2) APPEAL_ROLE,
		LEFT(ISNULL(DISPOSITION,'') + REPLICATE(' ',2),2) DISPOSITION,
		LEFT(ISNULL(DISP_REASON,'') + REPLICATE(' ',4),4) DISP_REASON,

		LEFT(CASE WHEN DISP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST
CREATE   PROCEDURE [dbo].[trac_write_gs_part_event]
	@l_district varchar(3),
	@mode int = 0
AS
BEGIN
---------------------------------------------------------- (28)(05)(04) ---------------------------------------------------------------------------
---------------------------------------------------------- GS_PART_EVENT ------------------------------------------------------------------------
--------------------------------------/*(28)(05)(04)*/ exec [dbo].[trac_write_gs_part_event] 'NYS', 6;  -- (PARTID) ----------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/*(28)(05)(04)*/ exec [dbo].[trac_write_gs_part_event] 'NYS', 4;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************

SET NOCOUNT ON
;
-- 'table_gs_part_event.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_PART_EVENT WITH (NOLOCK) WHERE DISTRICT = @l_district
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_PART_EVENT ('+@l_district+')',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(EVENTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) EVENTID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_EVENT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
	WHERE 1=1
	AND C.DISTRICT = @l_district
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(EVENTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) EVENTID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_EVENT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
	WHERE 1=1
	AND C.DISTRICT = @l_district
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(EVENTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) EVENTID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN TR1.TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1.TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1.TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1.TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1.TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1.TR1_STATE=999 THEN 'SEALED'
		WHEN TR1.TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1.TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
	END STATE_DESCRIPTION
	FROM 
	GS_PART_EVENT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DIST
CREATE    PROCEDURE [dbo].[trac_write_gs_part_event_combined]
@mode int = 0
AS
BEGIN
---------------------------------------------------------- (29)(05)(04) ---------------------------------------------------------------------------
---------------------------------------------------------- GS_PART_EVENT --------------------------------------------------------------------------
--------------------------------------/*(29)(05)(04)*/ exec [dbo].[trac_write_gs_part_event_combined] 6;  -- (PARTID) -----------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/*(29)(05)(04)*/ exec [dbo].[trac_write_gs_part_event_combined] 4; 
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_part_event.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_PART_EVENT WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'GENERATED=>GS_PART_EVENT',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(EVENTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) EVENTID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_EVENT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
	WHERE 1=1
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(EVENTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) EVENTID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_EVENT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
	WHERE 1=1
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(CRTHISID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID,
		LEFT(ISNULL(CAST(EVENTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) EVENTID,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN TR1.TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1.TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1.TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1.TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1.TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1.TR1_STATE=999 THEN 'SEALED'
		WHEN TR1.TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1.TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
	END STATE_DESCRIPTION
	FROM 
	GS_PART_EVENT C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	INNER JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = 
CREATE   PROCEDURE [dbo].[trac_write_gs_part_relief]
@mode int = 0
AS
BEGIN
------------------------------------------------------------(30)(04)(01)----------------------------------------------------------------------
---------------------------------------------------------- GS_PART_RELIEF ------------------------------------------------------------------------
--------------------------------------/*(30)(04)(01)*/ exec [dbo].[trac_write_gs_part_relief] 6;	-- (PARTID) 6;--------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(30)(04)(01)*/ exec [dbo].[trac_write_gs_part_relief] 6;		-- (PARTID) 
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_part_relief.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_PART_RELIEF WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_PART_RELIEF',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
SELECT 
	LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
	LEFT(ISNULL(CAST(RELIEFID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) RELIEFID,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_PART_RELIEF
WITH (NOLOCK)
WHERE 1=1
	--AND DISTRICT = 'AK'
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
SELECT TOP 1000
	LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
	LEFT(ISNULL(CAST(RELIEFID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) RELIEFID,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_PART_RELIEF
WITH (NOLOCK)
WHERE 1=1
	--AND DISTRICT = 'AK'
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
SELECT TOP 1000
	LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) PARTID,
	LEFT(ISNULL(CAST(RELIEFID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) RELIEFID,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

	,TR1.TR1_STATE AS RECORD_STATE
	,CASE 
	WHEN TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
	WHEN TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
	WHEN TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
	----------
	WHEN TR1_STATE=777 THEN 'NON-TR-PRE'
	WHEN TR1_STATE=888 THEN 'REGULAR-PUBLIC'
	WHEN TR1_STATE=999 THEN 'SEALED'
	WHEN TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
	WHEN TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
	END STATE_DESCRIPTION
FROM 
GS_PART_RELIEF AS C
WITH (NOLOCK)
INNER JOIN
dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
WHERE 1=1
	--AND DISTRICT = 'AK'
ORDER BY RECORD_STATE, DISTRICT, CASEID
;
END
;

CREATE   PROCEDURE [dbo].[trac_write_gs_part_victim]
@mode int = 0
AS
BEGIN
----------------------------------------------------------- (44)(05)(09) ----------------------------------------------------------------------------
---------------------------------------------------------- GS_PART_VICTIM ---------------------------------------------------------------------------
--------------------------------------/*(44)(05)(09)*/ exec [dbo].[trac_write_gs_part_victim] 6; exec [dbo].[trac_write_gs_part_victim] 6; ----------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(44)(05)(09)*/ exec [dbo].[trac_write_gs_part_victim] 6; --- GS_PART_VICTIM (Participant Victim)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'gs_part_victim.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_PART_VICTIM WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_PART_VICTIM',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT('*' + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		-- ------------------------------------------------
		LEFT(ISNULL(C.VICTIM_TYPE,' ')  + REPLICATE(' ',1),1) VICTIM_TYPE,
		LEFT('*' + REPLICATE(' ',1),1) PROSECUTION,
		LEFT('*' + REPLICATE(' ',11),11) VICTIM_TIMES,
		LEFT('*' + REPLICATE(' ',1),1) THREATS,
		LEFT(ISNULL(C.ELDERLY,' ') + REPLICATE(' ',1),1) ELDERLY,

		LEFT('*' + REPLICATE(' ',25),25) VICTIM_IDENTIFIER,
		LEFT('*' + REPLICATE(' ',14),14) STATE_COMP_RECVD,
		LEFT('*' + REPLICATE(' ',1),1) SERVICES_REQUESTED,

		LEFT(ISNULL(C.VIOLENT_CRIME,' ')  + REPLICATE(' ',1),1)  VIOLENT_CRIME,
		LEFT(ISNULL(C.DISABILITY,' ')  + REPLICATE(' ',1),1)  DISABILITY,
		LEFT('*' + REPLICATE(' ',1),1) NOTIFICAT_REQSTD,
		LEFT('*' + REPLICATE(' ',1),1) NOTIFICAT_RECVD,

		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_VICTIM C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET 
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT('*' + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		-- ------------------------------------------------
		LEFT(ISNULL(C.VICTIM_TYPE,' ')  + REPLICATE(' ',1),1) VICTIM_TYPE,
		LEFT('*' + REPLICATE(' ',1),1) PROSECUTION,
		LEFT('*' + REPLICATE(' ',11),11) VICTIM_TIMES,
		LEFT('*' + REPLICATE(' ',1),1) THREATS,
		LEFT(ISNULL(C.ELDERLY,' ') + REPLICATE(' ',1),1) ELDERLY,

		LEFT('*' + REPLICATE(' ',25),25) VICTIM_IDENTIFIER,
		LEFT('*' + REPLICATE(' ',14),14) STATE_COMP_RECVD,
		LEFT('*' + REPLICATE(' ',1),1) SERVICES_REQUESTED,

		LEFT(ISNULL(C.VIOLENT_CRIME,' ')  + REPLICATE(' ',1),1)  VIOLENT_CRIME,
		LEFT(ISNULL(C.DISABILITY,' ')  + REPLICATE(' ',1),1)  DISABILITY,
		LEFT('*' + REPLICATE(' ',1),1) NOTIFICAT_REQSTD,
		LEFT('*' + REPLICATE(' ',1),1) NOTIFICAT_RECVD,

		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_PART_VICTIM C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT TOP 1000 * FROM FSET 
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT('*' + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		-- ------------------------------------------------
		LEFT(ISNULL(C.VICTIM_TYPE,' ')  + REPLICATE(' ',1),1) VICTIM_TYPE,
		LEFT('*' + REPLICATE(' ',1),1) PROSECUTION,
		LEFT('*' + REPLICATE(' ',11),11) VICTIM_TIMES,
		LEFT('*' + REPLICATE(' ',1),1) THREATS,
		LEFT(ISNULL(C.ELDER
CREATE   PROCEDURE [dbo].[trac_write_gs_participant]
	-- Add the parameters for the stored procedure here
	@l_district varchar(3),
	@mode int = 0
AS
BEGIN
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(31)(01)(03)*/ exec [dbo].[trac_write_gs_participant] 'NYS', 5;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
;

DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_PARTICIPANT WITH (NOLOCK) WHERE DISTRICT = @l_district
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_PARTICIPANT ('+@l_district+')',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;	

IF @mode = 0
WITH FSET AS
(
	SELECT --TOP 15000	
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE P.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE P.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
	--LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR (TR1.TR1_STATE = 700) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID,
	LEFT(ISNULL(P.TYPE,'') + REPLICATE(' ',1),1) TYPE,
	--LEFT(CASE WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) THEN ISNULL(P.ROLE,'') ELSE CASE WHEN LEFT(P.ROLE,1) = 'D' THEN 'D*' ELSE '*' END  END + REPLICATE(' ',2),2) ROLE,
	LEFT(CASE 
	WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) AND LEFT(P.ROLE,1) = 'D' THEN 'D*' 
	WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) AND LEFT(P.ROLE,1) <> 'D' THEN '*'
	WHEN (RCL1.PROCESS_NAME IS NULL) AND ((RCL2.PROCESS_NAME IS NULL) OR (CCI.DISTRICT IS NOT NULL)) THEN ISNULL(P.ROLE,'')
	ELSE '*'  END + REPLICATE(' ',2),2) ROLE,

	LEFT('*' + REPLICATE(' ',1),1) SECURITY,
	LEFT(ISNULL(CAST(DEFEND_NUM AS VARCHAR(11)),'') + REPLICATE(' ',11),11) DEFEND_NUM,

	LEFT('*' + REPLICATE(' ',20),20) SALUTATION,
	LEFT(CASE WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (P.TYPE IN ( 'P', 'B')) OR (P.ROLE IN ('PR'))) THEN ISNULL(P.LAST_NAME,'') ELSE '*' END + REPLICATE(' ',60),60) LAST_NAME,
	LEFT(CASE WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (P.TYPE IN ( 'P', 'B')) OR (P.ROLE IN ('PR'))) THEN ISNULL(P.FIRST_NAME,'') ELSE '*' END + REPLICATE(' ',30),30) FIRST_NAME,

	LEFT('*' + REPLICATE(' ',30),30) TITLE,
	LEFT('*' + REPLICATE(' ',4),4) LAST_SOUNDS,
	LEFT('*' + REPLICATE(' ',4),4) FIRST_SOUNDS,

	LEFT(ISNULL(P.BUSINESS_TYPE,'') + REPLICATE(' ',2),2) BUSINESS_TYPE,

	LEFT('*' + REPLICATE(' ',20),20) EIN,

	LEFT(ISNULL(P.PROP_TYPE,'') + REPLICATE(' ',2),2) PROP_TYPE,
	LEFT(ISNULL(CAST(TOTAL_TRACTS AS VARCHAR(11)),'') + REPLICATE(' ',11),11) TOTAL_TRACTS,
	LEFT(ISNULL(P.CATS_ASSET_ID,'') + REPLICATE(' ',15),15) CATS_ASSET_ID,
	LEFT(ISNULL(P.AGENCY,'') + REPLICATE(' ',4),4) AGENCY,

	LEFT('*' + REPLICATE(' ',30),30) AGENCY_NUM,
	LEFT(ISNULL(P.JOB_POSITION,'') + REPLICATE(' ',4),4) JOB_POSITION,

	LEFT('*' + REPLICATE(' ',11),11) SSN,
	LEFT('*' + REPLICATE(' ',11),11) BIRTH_DATE,

	LEFT(ISNULL(P.GENDER,' ') + REPLICATE(' ',1),1) GENDER,
	LEFT('*' + REPLICATE(' ',1),1) JUVENILE,

	LEFT(ISNULL(RACE,'') + REPLICATE(' ',2),2) RACE,
	LEFT(ISNULL(RACE_DESCRIP,'') + REPLICATE(' ',30),30) RACE_DESCRIP,

	LEFT('*' + REPLICATE(' ',2),2) IMMIG_STAT,
	LEFT(CASE 
	WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' 
	WHEN ((RPL1.DISTRICT IS NOT NULL) OR (IDL.DISTRICT IS NOT NULL)) THEN ISNULL(P.COUNTRY,'')
	WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (P.TYPE IN ( 'P', 'B')) OR (P.ROLE IN ('PR'))) THEN ISNULL(P.COUNTRY,'') ELSE '*' END + REPLICATE(' ',2),2) COUNTRY,

	LEFT(ISNULL(TRIBE,'') + REPLICATE(' ',4),4) TRIBE,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE ISNULL(RESERVATION,'') END + REPLICATE(' ',4),4) RESERVATION,

	LEFT('*' + REPLICATE(' ',11),11) ARREST_DATE,
	LEFT('*' + REPLICATE(' ',12),12) PDID,
	LEFT('*' + REPLICATE(' ',15),15) FBI_NUMBER,

	LEFT(ISNULL(CRIM_HIST,'') + REPLICATE(' ',1),1) CRIM_HIST,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE CAST(EST_LOSS AS VARCHAR(14)) END ,'') + REPLICATE(' ',14),14) EST_LOSS,
	LEFT(ISNULL(CAST(ACT_LOSS AS VARCHAR(14)),'') + REPLICATE(' ',14),14) ACT_LOSS,

	LEFT('*' + REPLICATE(' ',30),30) HOME_ADDRESS1,
	LEFT('*' + REPLICATE(' ',30),30) HOME_ADDRESS2,
	LEFT('*' + REPLICATE(' ',30),30) HOME_ADDRESS3,

	LEFT(CASE 	
	WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' 
	WHEN ((RPL1.DISTRICT IS NOT NULL) OR (IDL.DISTRICT IS NOT NULL)) THEN ISNULL(P.HOME_CITY,'')  
	WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (P.TYPE IN ( 'P', 'B')) OR (P.ROLE IN ('PR'))) THEN ISNULL(P.HOME_CITY,'') ELSE '*' END + REPLICATE(' ',20),20) HOME_CITY,

	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE ISNULL(HOME_STATE,'') END + REPLICATE(' ',2),2) HOME_STATE,

	LEFT(CASE 	
	WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' 
	WHEN ((RPL1.DISTRICT IS NOT NULL) OR (IDL.DISTRICT IS NOT NULL)) THEN ISNULL(P.HOME_COUNTY,'')  
	WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (P.TYPE IN ( 'P', 'B')) OR (P.ROLE IN ('PR'))) THEN ISNULL(P.HOME_COUNTY,'') ELSE '*' END + REPLICATE(' ',20),20) HOME_COUNTY,

	LEFT(CASE 	
	WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' 
	WHEN ((RPL1.DISTRICT IS NOT NULL) OR (IDL.DISTRICT IS NOT NULL)) THEN ISNULL(P.HOME_ZIPCODE,'')  
	WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (P.TYPE IN ( 'P', 'B')) OR (P.ROLE IN ('PR'))) THEN ISNULL(P.HOME_ZIPCODE,'') ELSE '*' END + REPLICATE(' ',20),20) HOME_ZIPCODE,

	LEFT('*' + REPLICATE(' ',15),15) HOME_PHONE,
	LEFT('*' + REPLICATE(' ',15),15) HOME_FAX,
	LEFT('*' + REPLICATE(' ',30),30) OFF_ADDRESS1,
	LEFT('*' + REPLICATE(' ',30),30) OFF_ADDRESS2,
	LEFT('*' + REPLICATE(' ',30),30) OFF_ADDRESS3,

	LEFT(CASE 	
	WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' 
	WHEN ((RPL1.DISTRICT IS NOT NULL) OR (IDL.DISTRICT IS NOT NULL)) THEN ISNULL(P.OFF_CITY,'')  
	WHEN (RCL1.PROCESS_NAME IS NULL) AND (RCL2.PROCESS_NAME IS NULL) AND ((GD.DISTRICT IS NOT NULL) OR (P.TYPE IN ( 'P', 'B')) OR (P.ROLE IN ('PR'))) THEN ISNULL(P.OFF_CITY,'') ELSE '*' END + REPLICATE(' ',20),20) OFF_CITY,

	LEFT(ISNULL(OFF_STATE,'') + REPLICATE(' ',2),2) OFF_STATE,

	LEFT(CASE 	
	WHEN ((RCL1.PROCESS_NAME IS NOT NULL) OR (RCL2.PROCESS_NAME IS NOT NULL)) THEN '*' 
	WHEN ((RPL1.DISTRICT IS NOT NULL) OR (IDL.DISTRICT IS 
CREATE    PROCEDURE [dbo].[trac_write_gs_prop_value]
@mode int = 0
AS
BEGIN
----------------------------------------------------------------(32)(04)(02)----------------------------------------------------------------------------
---------------------------------------------------------- GS_PROP_VALUE ------------------------------------------------------------------------
--------------------------------------/*(32)(04)(02)*/ exec [dbo].[trac_write_gs_prop_value] 4;   -- (PARTID)-------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(32)(04)(02)*/ exec [dbo].[trac_write_gs_prop_value] 4;   -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'gs_prop_value.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_PROP_VALUE WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_PROP_VALUE',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;

IF @mode = 0
WITH FSET AS
(
SELECT 
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	LEFT(ISNULL(CAST(C.PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
	LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
	-- ------------------------------------------------
	LEFT(ISNULL(C.TYPE,'') + REPLICATE(' ',2),2) TYPE,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE ISNULL(REPLACE(CAST(C.VALUE AS VARCHAR(14)),'.00',''),' ') END + REPLICATE(' ',14),14) VALUE,
	LEFT(CASE WHEN PROP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(PROP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) PROP_DATE,
	-- ------------------------------------------------
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_PROP_VALUE C
WITH (NOLOCK)
----------------------------
LEFT JOIN
----------------------------
dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
AND C.DISTRICT = PDD.DISTRICT
AND C.CASEID = PDD.CASEID
----------------------------
LEFT JOIN
----------------------------
dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
AND C.DISTRICT = TER.DISTRICT
AND C.CASEID = TER.CASEID	
LEFT JOIN
dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
) 
SELECT * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID, ID
;
IF @mode = 4
WITH FSET AS
(
SELECT 
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	LEFT(ISNULL(CAST(C.PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
	LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
	-- ------------------------------------------------
	LEFT(ISNULL(C.TYPE,'') + REPLICATE(' ',2),2) TYPE,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE ISNULL(REPLACE(CAST(C.VALUE AS VARCHAR(14)),'.00',''),' ') END + REPLICATE(' ',14),14) VALUE,
	LEFT(CASE WHEN PROP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(PROP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) PROP_DATE,
	-- ------------------------------------------------
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_PROP_VALUE C
WITH (NOLOCK)
----------------------------
LEFT JOIN
----------------------------
dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
AND C.DISTRICT = PDD.DISTRICT
AND C.CASEID = PDD.CASEID
----------------------------
LEFT JOIN
----------------------------
dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
AND C.DISTRICT = TER.DISTRICT
AND C.CASEID = TER.CASEID	
LEFT JOIN
dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
) 
SELECT TOP 1000 * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID DESC, ID
;

IF @mode = 6
WITH FSET AS
(
SELECT 
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

	LEFT(ISNULL(CAST(C.PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
	LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
	-- ------------------------------------------------
	LEFT(ISNULL(C.TYPE,'') + REPLICATE(' ',2),2) TYPE,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' ELSE ISNULL(REPLACE(CAST(C.VALUE AS VARCHAR(14)),'.00',''),' ') END + REPLICATE(' ',14),14) VALUE,
	LEFT(CASE WHEN PROP_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(PROP_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) PROP_DATE,
	-- ------------------------------------------------
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11
CREATE    PROCEDURE [dbo].[trac_write_gs_region]
@mode int = 0
AS
BEGIN
----------------------------------------------------------(33)(04)(03)----------------------------------------------------------------------------
---------------------------------------------------------- GS_REGION ------------------------------------------------------------------------
--------------------------------------/*(33)(04)(03)*/ exec [dbo].[trac_write_gs_region];----------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(33)(04)(03)*/ exec [dbo].[trac_write_gs_region] 4;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_region.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_REGION WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_REGION',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;	  
IF @mode = 0
SELECT 
	LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',3),3) DISTRICT,
	LEFT(ISNULL(BRANCH,'') + REPLICATE(' ',3),3) BRANCH,
	LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',30),30) DESCRIPTION,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_REGION C
WITH (NOLOCK)
WHERE 1=1
	--AND DISTRICT = 'AK'
ORDER BY DISTRICT, BRANCH
;
IF @mode = 4
SELECT TOP 1000
	LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',3),3) DISTRICT,
	LEFT(ISNULL(BRANCH,'') + REPLICATE(' ',3),3) BRANCH,
	LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',30),30) DESCRIPTION,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_REGION C
WITH (NOLOCK)
WHERE 1=1
	--AND DISTRICT = 'AK'
ORDER BY DISTRICT, BRANCH DESC
;
END
;

CREATE   PROCEDURE [dbo].[trac_write_gs_relate_appeal]
@mode int = 0
AS
BEGIN
-------------------------------------------------------------(34)(04)(04)----------------------------------------------------------------------------
---------------------------------------------------------- GS_RELATE_APPEAL ------------------------------------------------------------------------
--------------------------------------/*(34)(04)(04)*/ exec [dbo].[trac_write_gs_relate_appeal] 6; -------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(34)(04)(04)*/ exec [dbo].[trac_write_gs_relate_appeal];
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'gs_relate_appeal.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_RELATE_APPEAL WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_RELATE_APPEAL',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID1 END ,'') + REPLICATE(' ',10),10) CASEID1,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR2.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID2 END ,'') + REPLICATE(' ',10),10) CASEID2,

		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		LEFT(ISNULL(CASE WHEN (TR2.TR1_STATE = 100) OR ((TER2.DISTRICT IS NOT NULL) AND (PDD2.DISTRICT IS NULL)) THEN CAST(TR2.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR2_UNIQUEID,

		LEFT(ISNULL(CAST(C.CRTHISID1 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) CRTHISID1,
		LEFT(ISNULL(CAST(C.CRTHISID2 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) CRTHISID2,
		LEFT(ISNULL(C.REASON,'') + REPLICATE(' ',2),2) REASON,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

	FROM 
	GS_RELATE_APPEAL C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID1) --AND (TR1.TR1_STATE = 100)
	LEFT JOIN
	dbo.TR1_CASE TR2 WITH (NOLOCK) ON 1=1 AND (TR2.TR1_DISTRICT = C.DISTRICT) AND (TR2.TR1_CASEID = C.CASEID2) --AND (TR1.TR1_STATE = 100)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID1 = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID1 = TER.CASEID	
		----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD2.DISTRICT
	AND C.CASEID2 = PDD2.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER2.DISTRICT
	AND C.CASEID2 = TER2.CASEID	
	WHERE 1=1
) 
SELECT * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID1, CASEID2
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID1 END ,'') + REPLICATE(' ',10),10) CASEID1,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR2.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID2 END ,'') + REPLICATE(' ',10),10) CASEID2,

		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		LEFT(ISNULL(CASE WHEN (TR2.TR1_STATE = 100) OR ((TER2.DISTRICT IS NOT NULL) AND (PDD2.DISTRICT IS NULL)) THEN CAST(TR2.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR2_UNIQUEID,

		LEFT(ISNULL(CAST(C.CRTHISID1 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) CRTHISID1,
		LEFT(ISNULL(CAST(C.CRTHISID2 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) CRTHISID2,
		LEFT(ISNULL(C.REASON,'') + REPLICATE(' ',2),2) REASON,
		-- ------------------------------------------------
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN TR1.TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1.TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1.TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1.TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1.TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1.TR1_STATE=999 THEN 'SEALED'
		WHEN TR1.TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1.TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
	END STATE_DESCRIPTION
	FROM 
	GS_RELATE_APPEAL C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID1) --AND (TR1.TR1_STATE = 100)
	LEFT JOIN
	dbo.TR1_CASE TR2 WITH (NOLOCK) ON 1=1 AND (TR2.TR1_DISTRICT = C.DISTRICT) AND (TR2.TR1_CASEID = C.CASEID2) --AND (TR1.TR1_STATE = 100)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID1 = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID1 = TER.CASEID	
		----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD2.DISTRICT
	AND C.CASEID2 = PDD2.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER2.DISTRICT
	AND C.CASEID2 = TER2.CASEID	
	WHERE 1=1
	--AND ((TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)) 
	--AND ((TR2.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR2.TR1_SYS_INIT_DA
CREATE    PROCEDURE [dbo].[trac_write_gs_relate_case]
@mode int = 0
AS
BEGIN
------------------------------------------------------------(35)(04)(05)----------------------------------------------------------------------------
---------------------------------------------------------- GS_RELATE_CASE --------------------------------------------------------------------------
--------------------------------------/*(35)(04)(05)*/ exec [dbo].[trac_write_gs_relate_case] 4;----------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(35)(04)(05)*/ exec [dbo].[trac_write_gs_relate_case] 6;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_relate_case.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_RELATE_CASE WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_RELATE_CASE',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID1 END ,'') + REPLICATE(' ',10),10) CASEID1,
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR2.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID2 END ,'') + REPLICATE(' ',10),10) CASEID2,

		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR2.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR2_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID1 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID1,
		LEFT(ISNULL(CAST(CRTHISID2 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID2,
		LEFT(ISNULL(REASON,' ') + REPLICATE(' ',2),2) REASON,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) OR  (TR2.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100)  OR  (TR2.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID
	FROM 
	GS_RELATE_CASE C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID1) --AND (TR1.TR1_STATE = 100)
	LEFT JOIN
	dbo.TR1_CASE TR2 WITH (NOLOCK) ON 1=1 AND (TR2.TR1_DISTRICT = C.DISTRICT) AND (TR2.TR1_CASEID = C.CASEID2) --AND (TR1.TR1_STATE = 100)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID1 = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID1 = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD2.DISTRICT
	AND C.CASEID2 = PDD2.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER2.DISTRICT
	AND C.CASEID2 = TER2.CASEID	
) 
SELECT * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID1, CASEID2
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID1 END ,'') + REPLICATE(' ',10),10) CASEID1,
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR2.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID2 END ,'') + REPLICATE(' ',10),10) CASEID2,

		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR2.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR2_UNIQUEID,

		LEFT(ISNULL(CAST(CRTHISID1 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID1,
		LEFT(ISNULL(CAST(CRTHISID2 AS VARCHAR(10)),'') + REPLICATE(' ',10),10) CRTHISID2,
		LEFT(ISNULL(REASON,' ') + REPLICATE(' ',2),2) REASON,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) OR  (TR2.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100)  OR  (TR2.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,

		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),'') + REPLICATE(' ',10),10) ID
	FROM 
	GS_RELATE_CASE C
	WITH (NOLOCK)
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID1) --AND (TR1.TR1_STATE = 100)
	LEFT JOIN
	dbo.TR1_CASE TR2 WITH (NOLOCK) ON 1=1 AND (TR2.TR1_DISTRICT = C.DISTRICT) AND (TR2.TR1_CASEID = C.CASEID2) --AND (TR1.TR1_STATE = 100)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID1 = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID1 = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD2.DISTRICT
	AND C.CASEID2 = PDD2.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER2 WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER2.DISTRICT
	AND C.CASEID2 = TER2.CASEID	
)
SELECT TOP 1000 * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID1 DESC, CASEID2
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STATE = 100) OR (TR2.TR1_STATE = 100)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID1 END ,'') + REPLICATE(' ',10),10) CASEID1,
		LEFT(ISNULL(CASE WHEN ((TR1.TR1_STAT
CREATE    PROCEDURE [dbo].[trac_write_gs_relate_part]
@mode int = 0
AS
BEGIN
------------------------------------------------------------(36)(04)(06)----------------------------------------------------------------------------
---------------------------------------------------------- GS_RELATE_PART --------------------------------------------------------------------------
--------------------------------------/*(36)(04)(06)*/ exec [dbo].[trac_write_gs_relate_part] 6;   -- (PARTID) -------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(36)(04)(06)*/ exec [dbo].[trac_write_gs_relate_part] 4;   -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_relate_part.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_RELATE_PART WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_RELATE_PART',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID1 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID1,
		LEFT(ISNULL(CAST(PARTID2 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID2,
		LEFT(ISNULL(REASON,' ') + REPLICATE(' ',2),2) REASON,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_RELATE_PART C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
) 
SELECT * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID1 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID1,
		LEFT(ISNULL(CAST(PARTID2 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID2,
		LEFT(ISNULL(REASON,' ') + REPLICATE(' ',2),2) REASON,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_RELATE_PART C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
) 
SELECT TOP 1000 * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID DESC
;

IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID1 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID1,
		LEFT(ISNULL(CAST(PARTID2 AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID2,
		LEFT(ISNULL(REASON,' ') + REPLICATE(' ',2),2) REASON,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN TR1.TR1_STATE=100 THEN 'TR1-PRE-AFTER-CUTOFF'
		WHEN TR1.TR1_STATE=600 THEN 'TR1-PRE-B4-CUTOFF'
		WHEN TR1.TR1_STATE=700 THEN 'TR1-PRE-CONVERTED-2-PUBLIC'
		----------
		WHEN TR1.TR1_STATE=777 THEN 'NON-TR-PRE'
		WHEN TR1.TR1_STATE=888 THEN 'REGULAR-PUBLIC'
		WHEN TR1.TR1_STATE=999 THEN 'SEALED'
		WHEN TR1.TR1_STATE=1000 THEN 'GOV-AS-DEFENDANT'
		WHEN TR1.TR1_STATE=2000 THEN 'BUS-OR-PROPERTY'
		END STATE_DESCRIPTION
	FROM 
	GS_RELATE_PART C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	
CREATE    PROCEDURE [dbo].[trac_write_gs_relief]
@mode int = 0
AS
BEGIN
----------------------------------------------------------(37)(04)(07)------------------------------------------------------------------------------
----------------------------------------------------------- GS_RELIEF ------------------------------------------------------------------------------
--------------------------------------/*(37)(04)(07)*/ exec [dbo].[trac_write_gs_relief] 4; --------------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(37)(04)(07)*/ exec [dbo].[trac_write_gs_relief] 4;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_relief.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_RELIEF WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_RELIEF',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
SELECT 
	LEFT(ISNULL(DISTRICT,' ') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,' ') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,

	LEFT(ISNULL(TYPE,' ') + REPLICATE(' ',1),1) TYPE,
	LEFT(ISNULL(STAGE,' ') + REPLICATE(' ',1),1) STAGE,
	LEFT(ISNULL(REQUESTED_BY,' ') + REPLICATE(' ',1),1) REQUESTED_BY,
	LEFT(ISNULL(LIABILITY,' ') + REPLICATE(' ',1),1) LIABILITY,

	LEFT(ISNULL(REPLACE(CAST(AMOUNT AS VARCHAR(16)),'.00',''),' ') + REPLICATE(' ',16),16) AMOUNT,
	LEFT('*'  + REPLICATE(' ',30),30) NONMONETARY,
	LEFT(ISNULL(AGENCY,' ') + REPLICATE(' ',4),4) AGENCY,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_RELIEF
WITH (NOLOCK)
WHERE 1=1
--AND DISTRICT = 'AK'
ORDER BY DISTRICT, CASEID 
;  
IF @mode = 4
SELECT TOP 1000
	LEFT(ISNULL(DISTRICT,' ') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,' ') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,

	LEFT(ISNULL(TYPE,' ') + REPLICATE(' ',1),1) TYPE,
	LEFT(ISNULL(STAGE,' ') + REPLICATE(' ',1),1) STAGE,
	LEFT(ISNULL(REQUESTED_BY,' ') + REPLICATE(' ',1),1) REQUESTED_BY,
	LEFT(ISNULL(LIABILITY,' ') + REPLICATE(' ',1),1) LIABILITY,

	LEFT(ISNULL(REPLACE(CAST(AMOUNT AS VARCHAR(16)),'.00',''),' ') + REPLICATE(' ',16),16) AMOUNT,
	LEFT('*'  + REPLICATE(' ',30),30) NONMONETARY,
	LEFT(ISNULL(AGENCY,' ') + REPLICATE(' ',4),4) AGENCY,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_RELIEF
WITH (NOLOCK)
WHERE 1=1
--AND DISTRICT = 'AK'
ORDER BY DISTRICT, CASEID 
;  
IF @mode = 6
SELECT TOP 1000
	LEFT(ISNULL(DISTRICT,' ') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,' ') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,

	LEFT(ISNULL(TYPE,' ') + REPLICATE(' ',1),1) TYPE,
	LEFT(ISNULL(STAGE,' ') + REPLICATE(' ',1),1) STAGE,
	LEFT(ISNULL(REQUESTED_BY,' ') + REPLICATE(' ',1),1) REQUESTED_BY,
	LEFT(ISNULL(LIABILITY,' ') + REPLICATE(' ',1),1) LIABILITY,

	LEFT(ISNULL(REPLACE(CAST(AMOUNT AS VARCHAR(16)),'.00',''),' ') + REPLICATE(' ',16),16) AMOUNT,
	LEFT('*'  + REPLICATE(' ',30),30) NONMONETARY,
	LEFT(ISNULL(AGENCY,' ') + REPLICATE(' ',4),4) AGENCY,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_RELIEF
WITH (NOLOCK)
WHERE 1=1
--AND DISTRICT = 'AK'
ORDER BY DISTRICT, CASEID 
;  
END
;

CREATE    PROCEDURE [dbo].[trac_write_gs_request]
@mode int = 0
AS
BEGIN
----------------------------------------------------------(38)(04)(08)------------------------------------------------------------------------------
---------------------------------------------------------- GS_REQUEST ------------------------------------------------------------------------------
--------------------------------------/*(38)(04)(08)*/ exec [dbo].[trac_write_gs_request] 6; -------------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(38)(04)(08)*/ exec [dbo].[trac_write_gs_request] 4;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'gs_request.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_REQUEST WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_REQUEST',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
SELECT 
	LEFT(ISNULL(C.DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
	LEFT(ISNULL(C.CASEID,'') + REPLICATE(' ',10),10) CASEID,
	LEFT('*' + REPLICATE(' ',10),10) STAFFID,
	-- ------------------------------------------------
	LEFT(CASE WHEN REQUEST_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(REQUEST_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) REQUEST_DATE,
	LEFT(CASE WHEN RECEIVE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(RECEIVE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) RECEIVE_DATE,
	LEFT(CASE WHEN RETURN_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(RETURN_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) RETURN_DATE,
	-- ------------------------------------------------
	LEFT( '*' + REPLICATE(' ',20),20) STORE_NUM,
	LEFT(ISNULL(C.BOXID,'') + REPLICATE(' ',9),9) BOXID,
	-- ------------------------------------------------
	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_REQUEST C
WITH (NOLOCK)
ORDER BY DISTRICT, CASEID 
;
IF @mode = 4
SELECT TOP 1000
	LEFT(ISNULL(C.DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
	LEFT(ISNULL(C.CASEID,'') + REPLICATE(' ',10),10) CASEID,
	LEFT('*' + REPLICATE(' ',10),10) STAFFID,
	-- ------------------------------------------------
	LEFT(CASE WHEN REQUEST_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(REQUEST_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) REQUEST_DATE,
	LEFT(CASE WHEN RECEIVE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(RECEIVE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) RECEIVE_DATE,
	LEFT(CASE WHEN RETURN_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(RETURN_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) RETURN_DATE,
	-- ------------------------------------------------
	LEFT( '*' + REPLICATE(' ',20),20) STORE_NUM,
	LEFT(ISNULL(C.BOXID,'') + REPLICATE(' ',9),9) BOXID,
	-- ------------------------------------------------
	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_REQUEST C
WITH (NOLOCK)
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
SELECT --TOP 1000
	LEFT(ISNULL(C.DISTRICT,'') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CAST(C.ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
	LEFT(ISNULL(C.CASEID,'') + REPLICATE(' ',10),10) CASEID,
	LEFT('*' + REPLICATE(' ',10),10) STAFFID,
	-- ------------------------------------------------
	LEFT(CASE WHEN REQUEST_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(REQUEST_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) REQUEST_DATE,
	LEFT(CASE WHEN RECEIVE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(RECEIVE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) RECEIVE_DATE,
	LEFT(CASE WHEN RETURN_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(RETURN_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) RETURN_DATE,
	-- ------------------------------------------------
	LEFT( '*' + REPLICATE(' ',20),20) STORE_NUM,
	LEFT(ISNULL(C.BOXID,'') + REPLICATE(' ',9),9) BOXID,
	-- ------------------------------------------------
	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
FROM 
GS_REQUEST C
WITH (NOLOCK)
ORDER BY DISTRICT, CASEID DESC
;
END
;

CREATE    PROCEDURE [dbo].[trac_write_gs_restitution]
@mode int = 0
AS
BEGIN
------------------------------------------------------------ (39)(04)(09) --------------------------------------------------------------------------
---------------------------------------------------------- GS_RESTITUTION --------------------------------------------------------------------------
--------------------------------------/*(39)(04)(09)*/ exec [dbo].[trac_write_gs_restitution] 6;  -- (PARTID)  -- (PARTID) -------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(39)(04)(09)*/ exec [dbo].[trac_write_gs_restitution] 4;  -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_restitution.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_RESTITUTION WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_RESTITUTION',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(VICTIMID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) VICTIMID,

		LEFT(ISNULL(TYPE,' ') + REPLICATE(' ',1),1) TYPE,
		LEFT(ISNULL(RECIPIENT,' ') + REPLICATE(' ',1),1) RECIPIENT,
		LEFT(ISNULL(REPLACE(CAST(AMOUNT AS VARCHAR(14)),'.00',''),' ') + REPLICATE(' ',14),14) AMOUNT,
		LEFT(ISNULL(LIABILITY,' ') + REPLICATE(' ',1),1) LIABILITY,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_RESTITUTION C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(VICTIMID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) VICTIMID,

		LEFT(ISNULL(TYPE,' ') + REPLICATE(' ',1),1) TYPE,
		LEFT(ISNULL(RECIPIENT,' ') + REPLICATE(' ',1),1) RECIPIENT,
		LEFT(ISNULL(REPLACE(CAST(AMOUNT AS VARCHAR(14)),'.00',''),' ') + REPLICATE(' ',14),14) AMOUNT,
		LEFT(ISNULL(LIABILITY,' ') + REPLICATE(' ',1),1) LIABILITY,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_RESTITUTION C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
) 
SELECT TOP 1000 * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID DESC
;
IF @mode = 6
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
		LEFT(ISNULL(CAST(ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
		LEFT(ISNULL(CAST(VICTIMID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) VICTIMID,

		LEFT(ISNULL(TYPE,' ') + REPLICATE(' ',1),1) TYPE,
		LEFT(ISNULL(RECIPIENT,' ') + REPLICATE(' ',1),1) RECIPIENT,
		LEFT(ISNULL(REPLACE(CAST(AMOUNT AS VARCHAR(14)),'.00',''),' ') + REPLICATE(' ',14),14) AMOUNT,
		LEFT(ISNULL(LIABILITY,' ') + REPLICATE(' ',1),1) LIABILITY,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER

		,TR1.TR1_STATE AS RECORD_STATE
		,CASE 
		WHEN
CREATE    PROCEDURE [dbo].[trac_write_gs_sentence]
@mode int = 0
AS
BEGIN
-------------------------------------------------------- (40)(04)(10) ------------------------------------------------------------------------------
--------------------------------------------------------- GS_SENTENCE ------------------------------------------------------------------------------
--------------------------------------/*(40)(04)(10)*/ exec [dbo].[trac_write_gs_sentence] 4;   -- (PARTID)  -- (PARTID) ---------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(40)(04)(10)*/ exec [dbo].[trac_write_gs_sentence];   -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_sentence.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_SENTENCE WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_SENTENCE',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
SELECT 
	LEFT(ISNULL(DISTRICT,' ') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,' ') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
	LEFT(CASE WHEN SENT_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SENT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SENT_DATE,


	LEFT(ISNULL(GUIDE_DEPART,' ') + REPLICATE(' ',1),1) GUIDE_DEPART,
	LEFT(ISNULL(INCAR_TYPE,' ') + REPLICATE(' ',3),3) INCAR_TYPE,
	LEFT(ISNULL(CAST(JUDGEID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) JUDGEID,

	LEFT(ISNULL(CAST(PROB_DAYS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) PROB_DAYS,
	LEFT(ISNULL(CAST(PROB_MONTHS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) PROB_MONTHS,
	LEFT(ISNULL(CAST(PROB_YEARS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) PROB_YEARS,

	LEFT(ISNULL(CAST(SUPER_REL_DAYS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) SUPER_REL_DAYS,
	LEFT(ISNULL(CAST(SUPER_REL_MONTHS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) SUPER_REL_MONTHS,
	LEFT(ISNULL(CAST(SUPER_REL_YEARS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) SUPER_REL_YEARS,
	LEFT(ISNULL(CAST(INCAR_DAYS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) INCAR_DAYS,
	LEFT(ISNULL(CAST(INCAR_MONTHS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) INCAR_MONTHS,
	LEFT(ISNULL(CAST(INCAR_YEARS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) INCAR_YEARS,
	LEFT(ISNULL(CAST(FINE AS VARCHAR(14)),' ') + REPLICATE(' ',14),14) FINE,
	--LEFT(ISNULL(REPLACE(CAST(SPEC_ASSESSMENT AS VARCHAR(14)),'.00',''),' ') + REPLICATE(' ',14),14) SPEC_ASSESSMENT,
	LEFT(ISNULL(CAST(SPEC_ASSESSMENT AS VARCHAR(14)),' ') + REPLICATE(' ',14),14) SPEC_ASSESSMENT, -- <2023-02-02>

	LEFT(ISNULL(DEBARRED,' ') + REPLICATE(' ',1),1) DEBARRED,
	LEFT(ISNULL(SPEC_CONDITION,' ') + REPLICATE(' ',4),4) SPEC_CONDITION,
	LEFT(ISNULL(PROBATION_REVOKED,' ') + REPLICATE(' ',1),1) PROBATION_REVOKED,
	LEFT(ISNULL(SUPER_REL_REVOKED,' ') + REPLICATE(' ',1),1) SUPER_REL_REVOKED,

	LEFT(ISNULL(CAST(TOTAL_REVOKED_DAYS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) TOTAL_REVOKED_DAYS,
	LEFT(ISNULL(CAST(TOTAL_REVOKED_MONTHS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) TOTAL_REVOKED_MONTHS,
	LEFT(ISNULL(CAST(TOTAL_REVOKED_YEARS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) TOTAL_REVOKED_YEARS,

	LEFT(ISNULL(RELATED_FLU_USAO,' ') + REPLICATE(' ',10),10) RELATED_FLU_USAO,
	LEFT(ISNULL(RELATED_FLU_SEQ,' ') + REPLICATE(' ',3),3) RELATED_FLU_SEQ,
	LEFT(ISNULL(CAST(COMM_SERV_HOURS AS VARCHAR(12)),' ') + REPLICATE(' ',12),12) COMM_SERV_HOURS,

	LEFT(CASE WHEN SYS_SENT_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SYS_SENT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYS_SENT_DATE,
	LEFT(ISNULL(CAST(RESTITUTION_AMT AS VARCHAR(16)),' ') + REPLICATE(' ',16),16) RESTITUTION_AMT,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT(CASE WHEN CREATE_USER IS NULL THEN ' ' ELSE '*' END + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT(CASE WHEN UPDATE_USER IS NULL THEN ' ' ELSE '*' END + REPLICATE(' ',30),30) UPDATE_USER,

	LEFT(ISNULL(SUPV_REL_INCAR_TYPE,' ') + REPLICATE(' ',1),1) SUPV_REL_INCAR_TYPE
FROM 
GS_SENTENCE
WITH (NOLOCK)
WHERE 1=1
--AND DISTRICT = 'AK'
ORDER BY DISTRICT, CASEID 
;
IF @mode = 4
SELECT TOP 1000
	LEFT(ISNULL(DISTRICT,' ') + REPLICATE(' ',10),10) DISTRICT,
	LEFT(ISNULL(CASEID,' ') + REPLICATE(' ',10),10) CASEID,
	LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,
	LEFT(CASE WHEN SENT_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SENT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SENT_DATE,


	LEFT(ISNULL(GUIDE_DEPART,' ') + REPLICATE(' ',1),1) GUIDE_DEPART,
	LEFT(ISNULL(INCAR_TYPE,' ') + REPLICATE(' ',3),3) INCAR_TYPE,
	LEFT(ISNULL(CAST(JUDGEID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) JUDGEID,

	LEFT(ISNULL(CAST(PROB_DAYS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) PROB_DAYS,
	LEFT(ISNULL(CAST(PROB_MONTHS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) PROB_MONTHS,
	LEFT(ISNULL(CAST(PROB_YEARS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) PROB_YEARS,

	LEFT(ISNULL(CAST(SUPER_REL_DAYS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) SUPER_REL_DAYS,
	LEFT(ISNULL(CAST(SUPER_REL_MONTHS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) SUPER_REL_MONTHS,
	LEFT(ISNULL(CAST(SUPER_REL_YEARS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) SUPER_REL_YEARS,
	LEFT(ISNULL(CAST(INCAR_DAYS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) INCAR_DAYS,
	LEFT(ISNULL(CAST(INCAR_MONTHS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) INCAR_MONTHS,
	LEFT(ISNULL(CAST(INCAR_YEARS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) INCAR_YEARS,
	LEFT(ISNULL(CAST(FINE AS VARCHAR(14)),' ') + REPLICATE(' ',14),14) FINE,
	--LEFT(ISNULL(REPLACE(CAST(SPEC_ASSESSMENT AS VARCHAR(14)),'.00',''),' ') + REPLICATE(' ',14),14) SPEC_ASSESSMENT,
	LEFT(ISNULL(CAST(SPEC_ASSESSMENT AS VARCHAR(14)),' ') + REPLICATE(' ',14),14) SPEC_ASSESSMENT, -- <2023-02-02>

	LEFT(ISNULL(DEBARRED,' ') + REPLICATE(' ',1),1) DEBARRED,
	LEFT(ISNULL(SPEC_CONDITION,' ') + REPLICATE(' ',4),4) SPEC_CONDITION,
	LEFT(ISNULL(PROBATION_REVOKED,' ') + REPLICATE(' ',1),1) PROBATION_REVOKED,
	LEFT(ISNULL(SUPER_REL_REVOKED,' ') + REPLICATE(' ',1),1) SUPER_REL_REVOKED,

	LEFT(ISNULL(CAST(TOTAL_REVOKED_DAYS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) TOTAL_REVOKED_DAYS,
	LEFT(ISNULL(CAST(TOTAL_REVOKED_MONTHS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) TOTAL_REVOKED_MONTHS,
	LEFT(ISNULL(CAST(TOTAL_REVOKED_YEARS AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) TOTAL_REVOKED_YEARS,

	LEFT(ISNULL(RELATED_FLU_USAO,' ') + REPLICATE(' ',10),10) RELATED_FLU_USAO,
	LEFT(ISNULL(RELATED_FLU_SEQ,' ') + REPLICATE(' ',3),3) RELATED_FLU_SEQ,
	LEFT(ISNULL(CAST(COMM_SERV_HOURS AS VARCHAR(12)),' ') + REPLICATE(' ',12),12) COMM_SERV_HOURS,

	LEFT(CASE WHEN SYS_SENT_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(SYS_SENT_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) SYS_SENT_DATE,
	LEFT(ISNULL(CAST(RESTITUTION_AMT AS VARCHAR(16)),' ') + REPLICATE(' ',16),16) RESTITUTION_AMT,

	LEFT(CASE
CREATE   PROCEDURE [dbo].[trac_write_gs_staff]
@mode int = 0
AS
BEGIN
---------------------------------------------------------- (41)(05)(05) ---------------------------------------------------------------------------
---------------------------------------------------------- GS_STAFF -------------------------------------------------------------------------------
--------------------------------------/*(41)(05)(05)*/ exec [dbo].[trac_write_gs_staff]; --------------------------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(41)(05)(05)*/ exec [dbo].[trac_write_gs_staff] 4;
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_staff.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_STAFF WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_STAFF',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
SELECT 
	LEFT(ISNULL(DISTRICT,' ') + REPLICATE(' ',3),3) DISTRICT,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
	LEFT('*' + REPLICATE(' ',18),18) USERNAME,

	LEFT(ISNULL(INITIALS,' ') + REPLICATE(' ',8),8) INITIALS,
	LEFT(ISNULL(INIT_STAT,' ') + REPLICATE(' ',1),1) INIT_STAT,
	LEFT(ISNULL(STAFF_TITLE,' ') + REPLICATE(' ',3),3) STAFF_TITLE,
	LEFT(ISNULL(SALUTATION,' ') + REPLICATE(' ',8),8) SALUTATION,
	LEFT(ISNULL(LAST_NAME,' ') + REPLICATE(' ',30),30) LAST_NAME,
	LEFT(ISNULL(FIRST_NAME,' ') + REPLICATE(' ',30),30) FIRST_NAME,
	LEFT(ISNULL(OFFICE_LOC,' ') + REPLICATE(' ',30),30) OFFICE_LOC,

	LEFT('*' + REPLICATE(' ',15),15) PHONE,
	LEFT(CASE WHEN ISSUED_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(ISSUED_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) ISSUED_DATE,

	LEFT('*' + REPLICATE(' ',40),40) DEFAULT_DIR,
	LEFT('*' + REPLICATE(' ',40),40) DEFAULT_PRINT,
	LEFT(ISNULL(DEFAULT_DC_LOC,' ') + REPLICATE(' ',2),2) DEFAULT_DC_LOC,
	LEFT(ISNULL(DEFAULT_BRANCH,' ') + REPLICATE(' ',3),3) DEFAULT_BRANCH,
	LEFT('*' + REPLICATE(' ',1),1) NAME_SEARCH,
	LEFT('*' + REPLICATE(' ',1),1) STAFF_SEC_TYPE,
	LEFT(ISNULL(STAFF_SECTION, '') + REPLICATE(' ',8),8) STAFF_SECTION,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,

	LEFT('*' + REPLICATE(' ',30),30) AD_USERNAME,
	LEFT('*' + REPLICATE(' ',25),25) LCMS_POSITION,
	LEFT(ISNULL(CASE_TYPE,' ') + REPLICATE(' ',10),10) CASE_TYPE,
	LEFT(ISNULL(ACTION_STAGE,' ') + REPLICATE(' ',10),10) ACTION_STAGE,
	LEFT('*' + REPLICATE(' ',30),30) DR_USERNAME,
	LEFT(ISNULL(GUID,' ') + REPLICATE(' ',30),30) GUID
FROM 
GS_STAFF
WITH (NOLOCK)
WHERE 1=1
--AND DISTRICT = 'AK'
ORDER BY DISTRICT, ID 
;	
IF @mode = 6
SELECT 
	LEFT(ISNULL(DISTRICT,' ') + REPLICATE(' ',3),3) DISTRICT,
	LEFT(ISNULL(CAST(ID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) ID,
	LEFT('*' + REPLICATE(' ',18),18) USERNAME,

	LEFT(ISNULL(INITIALS,' ') + REPLICATE(' ',8),8) INITIALS,
	LEFT(ISNULL(INIT_STAT,' ') + REPLICATE(' ',1),1) INIT_STAT,
	LEFT(ISNULL(STAFF_TITLE,' ') + REPLICATE(' ',3),3) STAFF_TITLE,
	LEFT(ISNULL(SALUTATION,' ') + REPLICATE(' ',8),8) SALUTATION,
	LEFT(ISNULL(LAST_NAME,' ') + REPLICATE(' ',30),30) LAST_NAME,
	LEFT(ISNULL(FIRST_NAME,' ') + REPLICATE(' ',30),30) FIRST_NAME,
	LEFT(ISNULL(OFFICE_LOC,' ') + REPLICATE(' ',30),30) OFFICE_LOC,

	LEFT('*' + REPLICATE(' ',15),15) PHONE,
	LEFT(CASE WHEN ISSUED_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(ISSUED_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) ISSUED_DATE,

	LEFT('*' + REPLICATE(' ',40),40) DEFAULT_DIR,
	LEFT('*' + REPLICATE(' ',40),40) DEFAULT_PRINT,
	LEFT(ISNULL(DEFAULT_DC_LOC,' ') + REPLICATE(' ',2),2) DEFAULT_DC_LOC,
	LEFT(ISNULL(DEFAULT_BRANCH,' ') + REPLICATE(' ',3),3) DEFAULT_BRANCH,
	LEFT('*' + REPLICATE(' ',1),1) NAME_SEARCH,
	LEFT('*' + REPLICATE(' ',1),1) STAFF_SEC_TYPE,
	LEFT(ISNULL(STAFF_SECTION, '') + REPLICATE(' ',8),8) STAFF_SECTION,

	LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
	LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
	LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER,

	LEFT('*' + REPLICATE(' ',30),30) AD_USERNAME,
	LEFT('*' + REPLICATE(' ',25),25) LCMS_POSITION,
	LEFT(ISNULL(CASE_TYPE,' ') + REPLICATE(' ',10),10) CASE_TYPE,
	LEFT(ISNULL(ACTION_STAGE,' ') + REPLICATE(' ',10),10) ACTION_STAGE,
	LEFT('*' + REPLICATE(' ',30),30) DR_USERNAME,
	LEFT(ISNULL(GUID,' ') + REPLICATE(' ',30),30) GUID
FROM 
GS_STAFF
WITH (NOLOCK)
WHERE 1=1
--AND DISTRICT = 'AK'
ORDER BY DISTRICT, ID 
;	
END
;

CREATE     PROCEDURE [dbo].[trac_write_gs_triggerlock]
@mode int = 0
AS
BEGIN
----------------------------------------------------------- (42)(05)(06) ---------------------------------------------------------------------------
---------------------------------------------------------- GS_TRIGGERLOCK --------------------------------------------------------------------------
--------------------------------------/*(42)(05)(06)*/ exec [dbo].[trac_write_gs_triggerlock];  -- (PARTID) --------------------------------------
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
----------------------------------------------/****>(42)(05)(06)*/ exec [dbo].[trac_write_gs_triggerlock] 4;  -- (PARTID)
-- *************************************************************************************************************************************************
-- *************************************************************************************************************************************************
SET NOCOUNT ON
;
-- 'table_gs_triggerlock.txt',
DECLARE @ROWCOUNT INT
SELECT @ROWCOUNT = COUNT(*) FROM GS_TRIGGERLOCK WITH (NOLOCK)
INSERT INTO dbo.A1_INITIAL_DATA_PUMP(table_name,record_count,stage) 
SELECT 'TRAC=>GENERATED=>GS_TRIGGERLOCK',@ROWCOUNT,MAX(stage) FROM dbo.A1_INITIAL_DATA_PUMP
;
IF @mode = 0
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,

		LEFT(ISNULL(BRADY_OFFENSE,' ') + REPLICATE(' ',1),1) BRADY_OFFENSE,
		LEFT(ISNULL(NOTICE_3_STRIKES,' ') + REPLICATE(' ',1),1) NOTICE_3_STRIKES,

		LEFT(CASE WHEN DATE_NOTICE_FILED IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DATE_NOTICE_FILED, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DATE_NOTICE_FILED,
		LEFT(CASE WHEN DATE_NOTICE_WITHDRAWN IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DATE_NOTICE_WITHDRAWN, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DATE_NOTICE_WITHDRAWN,

		LEFT(CASE WHEN WITHDRAWAL_REASON IS NULL THEN ' ' ELSE '*' END  + REPLICATE(' ',78),78) WITHDRAWAL_REASON,
		LEFT(ISNULL(CONVICTION_3_STRIKES,' ') + REPLICATE(' ',1),1) CONVICTION_3_STRIKES,
		LEFT(ISNULL(LIFE_3_STRIKES,' ') + REPLICATE(' ',1),1) LIFE_3_STRIKES,
		LEFT(CASE WHEN NO_LIFE_REASON IS NULL THEN ' ' ELSE '*' END  + REPLICATE(' ',78),78) NO_LIFE_REASON,

		LEFT(ISNULL(THIRD_PROSEC_TRIGG_OFFENSE,' ') + REPLICATE(' ',1),1) THIRD_PROSEC_TRIGG_OFFENSE,
		LEFT(ISNULL(TRIGGERLOCK_DEF,' ') + REPLICATE(' ',1),1) TRIGGERLOCK_DEF,
		LEFT(ISNULL(BAILEY_SENTENCE_CHANGE,' ') + REPLICATE(' ',1),1) BAILEY_SENTENCE_CHANGE,
		LEFT(ISNULL(CAST(SENTENCE_PRIOR_BAILEY AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) SENTENCE_PRIOR_BAILEY,
		LEFT(ISNULL(ARMED_CAREER_CRIMINAL,' ') + REPLICATE(' ',1),1) ARMED_CAREER_CRIMINAL,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_TRIGGERLOCK C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE > CFG.CUT_OFF_DATE) OR (TR1.TR1_SYS_INIT_DATE IS NULL)
)
SELECT * FROM FSET
WHERE 1=1
ORDER BY DISTRICT, CASEID
;
IF @mode = 4
WITH FSET AS
(
	SELECT 
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.DISTRICT END ,'') + REPLICATE(' ',10),10) DISTRICT,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE C.CASEID END ,'') + REPLICATE(' ',10),10) CASEID,
		LEFT(ISNULL(CASE WHEN (TR1.TR1_STATE = 100) OR ((TER.DISTRICT IS NOT NULL) AND (PDD.DISTRICT IS NULL)) THEN CAST(TR1.TR1_UNIQUEID AS VARCHAR(10)) ELSE '' END,'') + REPLICATE(' ',10),10) TR1_UNIQUEID,

		LEFT(ISNULL(CAST(PARTID AS VARCHAR(10)),' ') + REPLICATE(' ',10),10) PARTID,

		LEFT(ISNULL(BRADY_OFFENSE,' ') + REPLICATE(' ',1),1) BRADY_OFFENSE,
		LEFT(ISNULL(NOTICE_3_STRIKES,' ') + REPLICATE(' ',1),1) NOTICE_3_STRIKES,

		LEFT(CASE WHEN DATE_NOTICE_FILED IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DATE_NOTICE_FILED, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DATE_NOTICE_FILED,
		LEFT(CASE WHEN DATE_NOTICE_WITHDRAWN IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(DATE_NOTICE_WITHDRAWN, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) DATE_NOTICE_WITHDRAWN,

		LEFT(CASE WHEN WITHDRAWAL_REASON IS NULL THEN ' ' ELSE '*' END  + REPLICATE(' ',78),78) WITHDRAWAL_REASON,
		LEFT(ISNULL(CONVICTION_3_STRIKES,' ') + REPLICATE(' ',1),1) CONVICTION_3_STRIKES,
		LEFT(ISNULL(LIFE_3_STRIKES,' ') + REPLICATE(' ',1),1) LIFE_3_STRIKES,
		LEFT(CASE WHEN NO_LIFE_REASON IS NULL THEN ' ' ELSE '*' END  + REPLICATE(' ',78),78) NO_LIFE_REASON,

		LEFT(ISNULL(THIRD_PROSEC_TRIGG_OFFENSE,' ') + REPLICATE(' ',1),1) THIRD_PROSEC_TRIGG_OFFENSE,
		LEFT(ISNULL(TRIGGERLOCK_DEF,' ') + REPLICATE(' ',1),1) TRIGGERLOCK_DEF,
		LEFT(ISNULL(BAILEY_SENTENCE_CHANGE,' ') + REPLICATE(' ',1),1) BAILEY_SENTENCE_CHANGE,
		LEFT(ISNULL(CAST(SENTENCE_PRIOR_BAILEY AS VARCHAR(11)),' ') + REPLICATE(' ',11),11) SENTENCE_PRIOR_BAILEY,
		LEFT(ISNULL(ARMED_CAREER_CRIMINAL,' ') + REPLICATE(' ',1),1) ARMED_CAREER_CRIMINAL,

		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN CREATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) CREATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) CREATE_USER,
		LEFT(CASE WHEN (TR1.TR1_STATE = 100) THEN '#' WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(TRIM(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yyyy', 'en-US') AS VARCHAR(11)))) END + REPLICATE(' ',11),11) UPDATE_DATE,
		LEFT('*' + REPLICATE(' ',30),30) UPDATE_USER
	FROM 
	GS_TRIGGERLOCK C
	WITH (NOLOCK)
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_INITIATED_PRIOR_2_DELIVERY_DATE PDD WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = PDD.DISTRICT
	AND C.CASEID = PDD.CASEID
	----------------------------
	LEFT JOIN
	----------------------------
	dbo.IND_CASE_LEVEL_TERRORISM TER WITH (NOLOCK) ON 1=1
	AND C.DISTRICT = TER.DISTRICT
	AND C.CASEID = TER.CASEID	
	LEFT JOIN
	dbo.TR1_CASE TR1 WITH (NOLOCK) ON 1=1 AND (TR1.TR1_DISTRICT = C.DISTRICT) AND (TR1.TR1_CASEID = C.CASEID) --AND (TR1.TR1_STATE = 100)
	--CROSS JOIN TR1_CASE_CONFIG CFG WHERE (TR1.TR1_SYS_INIT_DATE 
CREATE   PROCEDURE [dbo].[write_table_gs_action]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_action 1;
exec [dbo].write_table_gs_action 2;
exec [dbo].write_table_gs_action 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_ACTION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_ACTION 
	ORDER BY DISTRICT, CODE 
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_ACTION 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_agency_off]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_agency_off 1;
exec [dbo].write_table_gs_agency_off 2;
exec [dbo].write_table_gs_agency_off 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_AGENCY_OFF'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District          ID AGEN Office                                                       Address1                       Address2                       Address3                       City                 State ZipCode    Salutation ChiefLastName                  ChiefFirstName                 ChiefTitle                     CreateDate CreateUser                     UpdateDate UpdateUser                                             '   
	UNION ALL
	SELECT '-------- ----------- ---- ------------------------------------------------------------ ------------------------------ ------------------------------ ------------------------------ -------------------- ----- ---------- ---------- ------------------------------ ------------------------------ ------------------------------ ---------- ------------------------------ ---------- ------------------------------   '
	;   

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CAST(ID AS VARCHAR(20)),'') + REPLICATE(' ',12),12) ID,
		LEFT(ISNULL(AGENCY,'') + REPLICATE(' ',5),5) AGENCY,

		LEFT(CASE WHEN OFFICE IS NULL THEN '' ELSE '*' END + REPLICATE(' ',61),61) OFFICE,
		LEFT(CASE WHEN ADDRESS1 IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) ADDRESS1,
		LEFT(CASE WHEN ADDRESS2 IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) ADDRESS2,
		LEFT(CASE WHEN ADDRESS3 IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) ADDRESS3,

		LEFT(ISNULL(CITY,'') + REPLICATE(' ',21),21) CITY,
		LEFT(ISNULL(STATE,'') + REPLICATE(' ',6),6) STATE,
		LEFT(ISNULL(ZIPCODE,'') + REPLICATE(' ',11),11) ZIPCODE,

		LEFT(CASE WHEN SALUTATION IS NULL THEN '' ELSE '*' END + REPLICATE(' ',11),11) SALUTATION,
		LEFT(CASE WHEN CHIEF_LAST_NAME IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) LN,
		LEFT(CASE WHEN CHIEF_FIRST_NAME IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) FN,
		LEFT(CASE WHEN CHIEF_TITLE IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) TITLE,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_AGENCY_OFF 
	ORDER BY DISTRICT, AGENCY, CHIEF_LAST_NAME, CHIEF_FIRST_NAME;
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_AGENCY_OFF 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_business_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_business_type 1;
exec [dbo].write_table_gs_business_type 2;
exec [dbo].write_table_gs_business_type 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_BUSINESS_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_BUSINESS_TYPE 
	ORDER BY DISTRICT, CODE , DESCRIPTION
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_BUSINESS_TYPE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_case_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_case_type 1;
exec [dbo].write_table_gs_case_type 2;
exec [dbo].write_table_gs_case_type 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_CASE_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    Type  CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser       '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ ----- -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;       
                           
           
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',6),6) TYPE,

		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CASE_TYPE 
	ORDER BY DISTRICT, CODE, DESCRIPTION, TYPE;
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_CASE_TYPE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_case_weight]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_case_weight 1;
exec [dbo].write_table_gs_case_weight 2;
exec [dbo].write_table_gs_case_weight 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_CASE_WEIGHT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CASE_WEIGHT 
	ORDER BY DISTRICT, CODE , DESCRIPTION
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_CASE_WEIGHT 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_charge_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].[write_table_gs_charge_type] 1;
exec [dbo].[write_table_gs_charge_type] 2;
exec [dbo].[write_table_gs_charge_type] 3;
*/

IF @mode = 1
	SELECT ''
	UNION ALL
	SELECT 'CODE                      DESCRIPTION                                                            C CREATE_DA C UPDATE_DA U'
	UNION ALL
	SELECT '------------------------- ---------------------------------------------------------------------- - --------- - --------- - '
--		    1234567890123456789012345
	--SELECT 'Code Description          CreateDate CreateUser                     UpdateDate UpdateUser                             '    
	--UNION ALL
 --   SELECT '---- -------------------- ---------- ------------------------------ ---------- ------------------------------'
--	        1234 12345678901234567890 12345678901234567890 1234567890 123456789012345678901234567890 1234567890 123456789012345678901234567890
	;
IF @mode = 2
/*
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',26),26) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',2),2) CODE_STAT,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',10),10) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN ' ' ELSE '*' END + REPLICATE(' ',2),2) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',10),10) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN ' ' ELSE '*' END + REPLICATE(' ',2),2) AS UPDATE_USER
	FROM 
		GS_CHARGE_TYPE 
	ORDER BY CODE 
	;
*/
	SELECT 
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',26),26) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',2),2) CODE_STAT,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE TRIM(UPPER(CAST(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US') AS VARCHAR(10)))) END + REPLICATE(' ',10),10) AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN ' ' ELSE '*' END + REPLICATE(' ',2),2) CREATE_USER,
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(CAST(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US') AS VARCHAR(10))) END + REPLICATE(' ',10),10) AS UPDATE_DATE,
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN ' ' ELSE '*' END + REPLICATE(' ',2),2) AS UPDATE_USER
	FROM 
		GS_CHARGE_TYPE 
	ORDER BY CODE 
	;
END
;
CREATE   PROCEDURE [dbo].[write_table_gs_counsel_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_counsel_type 1;
exec [dbo].write_table_gs_counsel_type 2;
exec [dbo].write_table_gs_counsel_type 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_COUNSEL_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                              CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser   '   
	UNION ALL
	SELECT '-------- ---- ---------------------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------   '
	;                                               
                        
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',41),41) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_COUNSEL_TYPE 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_COUNSEL_TYPE 
	;
END
;

CREATE   PROCEDURE [dbo].[write_table_gs_court_loc]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_court_loc 1;
exec [dbo].write_table_gs_court_loc 2;
exec [dbo].write_table_gs_court_loc 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_COURT_LOC'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District CO LO Description                                                  CreateDate CreateUser                     UpdateDate UpdateUser   '   
	UNION ALL
	SELECT '-------- -- -- ------------------------------------------------------------ ---------- ------------------------------ ---------- ------------------------------        '
	;      
               
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(COURT,'') + REPLICATE(' ',3),3) COURT,
		LEFT(ISNULL(LOCATION,'') + REPLICATE(' ',3),3) LOCATION,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',61),61) DESCRIPTION,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_COURT_LOC 
	ORDER BY DISTRICT, COURT, LOCATION, DESCRIPTION
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_COURT_LOC 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_custody_loc]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_custody_loc 1;
exec [dbo].write_table_gs_custody_loc 2;
exec [dbo].write_table_gs_custody_loc 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_CUSTODY_LOC'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_CUSTODY_LOC 
	ORDER BY DISTRICT, CODE , DESCRIPTION
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_CUSTODY_LOC 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_deten_reason]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_deten_reason 1;
exec [dbo].write_table_gs_deten_reason 2;
exec [dbo].write_table_gs_deten_reason 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_DETEN_REASON'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_DETEN_REASON 
	ORDER BY DISTRICT, CODE , DESCRIPTION
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_DETEN_REASON 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_event_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_event_type 1;
exec [dbo].write_table_gs_event_type 2;
exec [dbo].write_table_gs_event_type 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_EVENT_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                                                            Type  CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser           '   
	UNION ALL
	SELECT '-------- ---- ---------------------------------------------------------------------- ----- -------- ------- ---------- ------------------------------ ---------- ------------------------------    '
	;      
                      
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',71),71) DESCRIPTION,
		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',5),5) TYPE,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_EVENT_TYPE 
	ORDER BY DISTRICT, CODE, DESCRIPTION, TYPE;
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_EVENT_TYPE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_evid_disp]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_evid_disp 1;
exec [dbo].write_table_gs_evid_disp 2;
exec [dbo].write_table_gs_evid_disp 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_EVID_DISP'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description               CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser           '
	UNION ALL
	SELECT '-------- ---- ------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------    '
	;
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',26),26) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_EVID_DISP 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_EVID_DISP 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_evid_location]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_evid_location 1;
exec [dbo].write_table_gs_evid_location 2;
exec [dbo].write_table_gs_evid_location 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_EVID_LOCATION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                      ' 
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------ '
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_EVID_LOCATION 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_EVID_LOCATION 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_evid_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_evid_disp 1;
exec [dbo].write_table_gs_evid_disp 2;
exec [dbo].write_table_gs_evid_disp 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_EVID_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                              CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                                     '   
	UNION ALL
	SELECT '-------- ---- ---------------------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------'
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',41),41) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_EVID_TYPE 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_EVID_TYPE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_expert]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_expert 1;
exec [dbo].write_table_gs_expert 2;
exec [dbo].write_table_gs_expert 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_EXPERT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District          ID Initials InitStat Type SSN         Salutation LastName                       FirstName                      Title                          Address1                       Address2                       Address3                       City                 State ZipCode    Phone           Fax             CreateDate CreateUser                     UpdateDate UpdateUser               '   
	UNION ALL
	SELECT '-------- ----------- -------- -------- ---- ----------- ---------- ------------------------------ ------------------------------ ------------------------------ ------------------------------ ------------------------------ ------------------------------ -------------------- ----- ---------- --------------- --------------- ---------- ------------------------------ ---------- ------------------------------   '
	;   

IF @mode = 2
	SELECT 
		--LAST_NAME AS LLN,
		--FIRST_NAME AS FFN,
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CAST(ID AS VARCHAR(20)),'') + REPLICATE(' ',12),12) CODE,
		LEFT(CASE WHEN INITIALS IS NULL THEN '' ELSE '*' END + REPLICATE(' ',9),9) INITIALS,
		LEFT(ISNULL(INIT_STAT,'') + REPLICATE(' ',9),9) INIT_STAT,

		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',5),5) TYPE,
		LEFT(CASE WHEN SSN IS NULL THEN '' ELSE '*' END + REPLICATE(' ',12),12) SSN,

		LEFT(CASE WHEN SALUTATION IS NULL THEN '' ELSE '*' END + REPLICATE(' ',11),11) SALUTATION,
		LEFT(CASE WHEN LAST_NAME IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) LN,
		LEFT(CASE WHEN FIRST_NAME IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) FN,
		LEFT(CASE WHEN TITLE IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) TITLE,
		LEFT(CASE WHEN ADDRESS1 IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) ADDRESS1,
		LEFT(CASE WHEN ADDRESS2 IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) ADDRESS2,
		LEFT(CASE WHEN ADDRESS3 IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) ADDRESS3,

		LEFT(ISNULL(CITY,'') + REPLICATE(' ',21),21) CITY,
		LEFT(ISNULL(STATE,'') + REPLICATE(' ',6),6) STATE,
		LEFT(ISNULL(ZIPCODE,'') + REPLICATE(' ',11),11) ZIPCODE,

		LEFT(CASE WHEN PHONE IS NULL THEN '' ELSE '*' END + REPLICATE(' ',16),16) PHONE,
		LEFT(CASE WHEN FAX IS NULL THEN '' ELSE '*' END + REPLICATE(' ',16),16) FAX,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_EXPERT 
	ORDER BY DISTRICT, LAST_NAME, FIRST_NAME 
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_EXPERT 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_expert_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_expert_type 1;
exec [dbo].write_table_gs_expert_type 2;
exec [dbo].write_table_gs_expert_type 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_EXPERT_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_EXPERT_TYPE 
	ORDER BY DISTRICT, CODE , DESCRIPTION
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_EXPERT_TYPE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_immig_stat]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_immig_stat 1;
exec [dbo].write_table_gs_immig_stat 2;
exec [dbo].write_table_gs_immig_stat 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_IMMIG_STAT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_IMMIG_STAT 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_IMMIG_STAT 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_job_position]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_job_position 1;
exec [dbo].write_table_gs_job_position 2;
exec [dbo].write_table_gs_job_position 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_JOB_POSITION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_JOB_POSITION 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_JOB_POSITION 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_judge]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_judge 1;
exec [dbo].write_table_gs_judge 2;
exec [dbo].write_table_gs_judge 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_JUDGE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District          ID Initials Stat LastName                       FirstName                      CourtRoom                 Type CreateDate CreateUser                     UpdateDate UpdateUser    '   
	UNION ALL
	SELECT '-------- ----------- -------- ---- ------------------------------ ------------------------------ ------------------------- ---- ---------- ------------------------------ ---------- ------------------------------   '
	;   
                
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CAST(ID AS VARCHAR(20)),'') + REPLICATE(' ',12),12) CODE,
		LEFT(ISNULL(INITIALS,'') + REPLICATE(' ',9),9) INITIALS,
		LEFT(ISNULL(INIT_STAT,'') + REPLICATE(' ',5),5) INIT_STAT,

		LEFT(ISNULL(LAST_NAME,'') + REPLICATE(' ',31),31) LAST_NAME,
		LEFT(ISNULL(FIRST_NAME,'') + REPLICATE(' ',31),31) FIRST_NAME,
		LEFT(ISNULL(COURT_ROOM_NUM,'') + REPLICATE(' ',26),26) COURT_ROOM_NUM,
		LEFT(ISNULL(TYPE,'') + REPLICATE(' ',5),5) TYPE,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_JUDGE 
	ORDER BY DISTRICT, LAST_NAME, FIRST_NAME 
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_JUDGE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_judge_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_judge_type 1;
exec [dbo].write_table_gs_judge_type 2;
exec [dbo].write_table_gs_judge_type 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_JUDGE_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                    ' 
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_JUDGE_TYPE 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_JUDGE_TYPE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_lit_track]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_lit_track 1;
exec [dbo].write_table_gs_lit_track 2;
exec [dbo].write_table_gs_lit_track 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_LIT_TRACK'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                    ' 
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_LIT_TRACK
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_LIT_TRACK 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_location]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_location 1;
exec [dbo].write_table_gs_location 2;
exec [dbo].write_table_gs_location 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_LOCATION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_LOCATION 
	ORDER BY DISTRICT, CODE , DESCRIPTION
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_LOCATION 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_oppose_attorn]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_oppose_attorn 1;
exec [dbo].write_table_gs_oppose_attorn 2;
exec [dbo].write_table_gs_oppose_attorn 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_OPPOSE_ATTORN'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District          ID Initials   InitStat Salutation LastName                       FirstName                      Title                          Firm                                               Address1                       Address2                       Address3                       City                 State ZipCode    Phone           Fax             CreateDate CreateUser                     UpdateDate UpdateUser                      '   
	UNION ALL
	SELECT '-------- ----------- ---------- -------- ---------- ------------------------------ ------------------------------ ------------------------------ -------------------------------------------------- ------------------------------ ------------------------------ ------------------------------ -------------------- ----- ---------- --------------- --------------- ---------- ------------------------------ ---------- ------------------------------          '
	;   

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CAST(ID AS VARCHAR(20)),'') + REPLICATE(' ',12),12) CODE,
		LEFT(CASE WHEN INITIALS IS NULL THEN '' ELSE '*' END + REPLICATE(' ',11),11) INITIALS,
		LEFT(ISNULL(INIT_STAT,'') + REPLICATE(' ',9),9) INIT_STAT,

		LEFT(CASE WHEN SALUTATION IS NULL THEN '' ELSE '*' END + REPLICATE(' ',11),11) SALUTATION,
		LEFT(CASE WHEN LAST_NAME IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) LN,
		LEFT(CASE WHEN FIRST_NAME IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) FN,
		LEFT(CASE WHEN TITLE IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) TITLE,
		LEFT(CASE WHEN FIRM IS NULL THEN '' ELSE '*' END + REPLICATE(' ',51),51) FIRM,
		LEFT(CASE WHEN ADDRESS1 IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) ADDRESS1,
		LEFT(CASE WHEN ADDRESS2 IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) ADDRESS2,
		LEFT(CASE WHEN ADDRESS3 IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) ADDRESS3,

		LEFT(ISNULL(CITY,'') + REPLICATE(' ',21),21) CITY,
		LEFT(ISNULL(STATE,'') + REPLICATE(' ',6),6) STATE,
		LEFT(ISNULL(ZIPCODE,'') + REPLICATE(' ',11),11) ZIPCODE,

		LEFT(CASE WHEN PHONE IS NULL THEN '' ELSE '*' END + REPLICATE(' ',16),16) PHONE,
		LEFT(CASE WHEN FAX IS NULL THEN '' ELSE '*' END + REPLICATE(' ',16),16) FAX,

		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_OPPOSE_ATTORN 
	ORDER BY DISTRICT, LAST_NAME, FIRST_NAME 
	;

IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_OPPOSE_ATTORN 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_position]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_position 1;
exec [dbo].write_table_gs_position 2;
exec [dbo].write_table_gs_position 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_POSITION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                    ' 
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_POSITION
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_POSITION 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_prop_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_prop_type 1;
exec [dbo].write_table_gs_prop_type 2;
exec [dbo].write_table_gs_prop_type 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_PROP_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                    ' 
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------'

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_PROP_TYPE
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_PROP_TYPE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_prop_value_type]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_prop_value_type 1;
exec [dbo].write_table_gs_prop_value_type 2;
exec [dbo].write_table_gs_prop_value_type 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_PROP_VALUE_TYPE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                                        CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                            '   
	UNION ALL
	SELECT '-------- ---- -------------------------------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------        '
	;             
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',51),51) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_PROP_VALUE_TYPE 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_PROP_VALUE_TYPE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_relate_case_reason]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_relate_case_reason 1;
exec [dbo].write_table_gs_relate_case_reason 2;
exec [dbo].write_table_gs_relate_case_reason 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_RELATE_CASE_REASON'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                                        CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                            '   
	UNION ALL
	SELECT '-------- ---- -------------------------------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------        '
	;             
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',51),51) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_RELATE_CASE_REASON 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_RELATE_CASE_REASON 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_relate_part_reason]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_relate_part_reason 1;
exec [dbo].write_table_gs_relate_part_reason 2;
exec [dbo].write_table_gs_relate_part_reason 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_RELATE_PART_REASON'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                    CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                           '   
	UNION ALL
	SELECT '-------- ---- ------------------------------ -------- ------- ---------- ------------------------------ ---------- ------------------------------     '
	;      
                              
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',31),31) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_RELATE_PART_REASON 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_RELATE_PART_REASON 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_reservation]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_reservation 1;
exec [dbo].write_table_gs_reservation 2;
exec [dbo].write_table_gs_reservation 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_RESERVATION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                              CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser              '   
	UNION ALL
	SELECT '-------- ---- ---------------------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------    '
	;      
                         
IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',41),41) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_RESERVATION 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_RESERVATION 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_security]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_security 1;
exec [dbo].write_table_gs_security 2;
exec [dbo].write_table_gs_security 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_SECURITY'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                              CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                                     '   
	UNION ALL
	SELECT '-------- ---- ---------------------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------'
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',41),41) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_SECURITY 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_SECURITY 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_staff_section]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_staff_section 1;
exec [dbo].write_table_gs_staff_section 2;
exec [dbo].write_table_gs_staff_section 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_STAFF_SECTION'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code     Description                                        CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser      '   
	UNION ALL
	SELECT '-------- -------- -------------------------------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------ '
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',9),9) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',51),51) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_STAFF_SECTION 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_STAFF_SECTION 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_staff_title]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_staff_title 1;
exec [dbo].write_table_gs_staff_title 2;
exec [dbo].write_table_gs_staff_title 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_STAFF_TITLE'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                                        CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                       '   
	UNION ALL
	SELECT '-------- ---- -------------------------------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------   '
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',51),51) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_STAFF_TITLE 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_STAFF_TITLE 
	;

END
;

CREATE   PROCEDURE [dbo].[write_table_gs_unit]
@mode int = 1
AS
BEGIN
/*
exec [dbo].write_table_gs_unit 1;
exec [dbo].write_table_gs_unit 2;
exec [dbo].write_table_gs_unit 3;
*/

IF @mode = 1
	SELECT 'Date: ' + UPPER(FORMAT( GETDATE(), 'dd-MMM-yyyy', 'en-US')) + REPLICATE(' ',70) + 'GS_UNIT'
	UNION ALL
	SELECT ''
	UNION ALL
	SELECT 'District Code Description                              CodeStat GlbCode CreateDate CreateUser                     UpdateDate UpdateUser                             '   
	UNION ALL
	SELECT '-------- ---- ---------------------------------------- -------- ------- ---------- ------------------------------ ---------- ------------------------------       '
	;

IF @mode = 2
	SELECT 
		LEFT(ISNULL(DISTRICT,'') + REPLICATE(' ',9),9) DISTRICT,
		LEFT(ISNULL(CODE,'') + REPLICATE(' ',5),5) CODE,
		LEFT(ISNULL(DESCRIPTION,'') + REPLICATE(' ',41),41) DESCRIPTION,
		LEFT(ISNULL(CODE_STAT,'') + REPLICATE(' ',9),9) CODE_STAT,
		LEFT(ISNULL(GLB_CODE,'') + REPLICATE(' ',8),8) GLB_CODE,
		LEFT(CASE WHEN CREATE_DATE IS NULL THEN '' ELSE RTRIM(LTRIM(UPPER(FORMAT(CREATE_DATE, 'dd-MMM-yy', 'en-US')))) END + REPLICATE(' ',11),11) + --AS CREATE_DATE,
		LEFT(CASE WHEN CREATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) +
		LEFT(CASE WHEN UPDATE_DATE IS NULL THEN '' ELSE UPPER(FORMAT(UPDATE_DATE, 'dd-MMM-yy', 'en-US')) END + REPLICATE(' ',11),11) +
		LEFT(CASE WHEN UPDATE_USER IS NULL THEN '' ELSE '*' END + REPLICATE(' ',31),31) AS UPDATE_USER
	FROM 
		GS_UNIT 
	ORDER BY DISTRICT, CODE 
	;
IF @mode = 3
	SELECT ''
	UNION ALL
	SELECT CAST(COUNT(*) AS VARCHAR(20)) + ' rows selected.'
	FROM 
		GS_UNIT 
	;

END
;

